package org.maachang.comet;

/**
 * MaachangComet実行処理.
 * 
 * @version 2007/12/16
 * @author masahito suzuki
 * @since MaachangComet 1.05
 */
public class MComet {
    
    private static final void defaultLog4j() {
        System.setProperty( "log4j.configuration","conf/log4j.xml" ) ;
    }
    
    private static final void scriptLog4j() {
        System.setProperty( "log4j.configuration","conf/log4j-script.xml" ) ;
    }
    
    public static final void main( String[] args ) throws Exception {
        if( args == null || args.length <= 0 ) {
            System.out.println( "実行コマンドを指定してください" ) ;
            return ;
        }
        int len = args.length ;
        String cmd = args[ 0 ] ;
        String[] cargs = new String[ len-1 ] ;
        if( len > 1 ) {
            System.arraycopy( args,1,cargs,0,len-1 ) ;
        }
        cmd = cmd.trim().toLowerCase() ;
        if( "mserver".equals( cmd ) ) {
            defaultLog4j() ;
            Startup.main( cargs ) ;
        }
        else if( "mdown".equals( cmd ) ) {
            defaultLog4j() ;
            Shutdown.main( cargs ) ;
        }
        else if( "mproj".equals( cmd ) ) {
            defaultLog4j() ;
            Project.main( cargs ) ;
        }
        else if( "mtable".equals( cmd ) ) {
            defaultLog4j() ;
            OutputTable.main( cargs ) ;
        }
        else if( "mscript".equals( cmd ) ) {
            scriptLog4j() ;
            ConsoleScript.main( cargs ) ;
        }
        else {
            System.out.println( "コマンド["+cmd+"]はサポートされていません" ) ;
        }
    }
}
