package org.maachang.comet.httpd.engine.script.image;

import java.io.ByteArrayInputStream;
import java.net.InetAddress;

import org.maachang.dbm.MDbm;
import org.maachang.dbm.MDbmManager;
import org.maachang.dbm.service.client.MDbmDriverManager;
import org.maachang.util.image.BaseImageConvertor;
import org.maachang.util.image.ImageConvertor;
import org.maachang.util.image.ImageInfo;

/**
 * イメージマネージャ.
 * 
 * @version 2008/01/27
 * @author masahito suzuki
 * @since MaachangComet 1.07
 */
public class ImageManager {
    
    private ImageManager() {
        
    }
    
    /**
     * イメージ操作オブジェクトを取得.
     * <BR><BR>
     * イメージ操作オブジェクトを取得します.
     * <BR>
     * @param mdbm 対象のMDBMを設定します.
     * @return ImageOp イメージ操作オブジェクトが返されます.
     * @exception Exception 例外.
     */
    public static final ImageOp getImageOp( MDbm mdbm ) throws Exception {
        return new ImageOpImpl( mdbm ) ;
    }
    
    /**
     * イメージ操作オブジェクトを取得.
     * <BR><BR>
     * イメージ操作オブジェクトを取得します.
     * <BR>
     * @param mode [true]の場合、トランザクションモードです.
     * @return ImageOp イメージ操作オブジェクトが返されます.
     * @exception Exception 例外.
     */
    public static final ImageOp getImageOp( boolean mode ) throws Exception {
        return new ImageOpImpl( MDbmManager.getInstance().getMDbm( mode ) ) ;
    }
    
    /**
     * 外部接続用イメージ操作オブジェクトを取得.
     * <BR><BR>
     * 外部接続用イメージ操作オブジェクトを取得します.
     * <BR>
     * @param addr コネクションアドレスを設定します.
     * @param port コネクションポート番号を設定します.
     * @return ImageOp イメージ操作オブジェクトが返されます.
     */
    public static final ImageOp getImageOp( InetAddress addr,int port ) {
        ImageOp ret = null ;
        try {
            ret = new ImageOpImpl( MDbmDriverManager.getConnection( addr,port ) ) ;
        } catch( Exception e ) {
            ret = null ;
        }
        return ret ;
    }
    
    /**
     * 画像タイプを取得.
     * <BR><BR>
     * 指定バイナリを解析して、画像タイプを取得します.
     * <BR>
     * @param binary 対象のバイナリを設定します.
     * @return String 画像タイプが返されます.
     * @exception Exception 例外.
     */
    public static final String getImageCodec( byte[] binary )
        throws Exception {
        return BaseImageConvertor.getImageFormat( new ByteArrayInputStream( binary ) ) ;
    }
    
    /**
     * 画像解像度を取得.
     * <BR><BR>
     * 画像解像度が返されます.
     * <BR>
     * @param binary 対象のバイナリを設定します.
     * @return int[] 画像解像度が返されます.
     * @exception Exception 例外.
     */
    public static final int[] getImageWidthHeight( byte[] binary )
        throws Exception {
        ImageInfo img = ImageConvertor.loadImage( new ByteArrayInputStream( binary ) ) ;
        return new int[]{ img.getWidth(),img.getHeight() } ;
    }
}
