package org.maachang.comet.net.nio ;

import java.util.LinkedList;

/**
 * 読み込み可能キュー.
 * 
 * @version 2008/05/28
 * @author  masahito suzuki
 * @since   MaachangComet 1.1B
 */
class IsReadQueue {
    private LinkedList<NioElement> queue = null ;
    
    public IsReadQueue() {
        queue = new LinkedList<NioElement>() ;
    }
    
    public synchronized void destroy() {
        if( queue != null ) {
            queue.clear() ;
        }
    }
    
    public synchronized void append( NioElement element ) {
        if( element == null || element == null ) {
            return ;
        }
        queue.add( element ) ;
    }
    
    public synchronized NioElement getQueue() {
        if( queue == null || queue.size() <= 0 ) {
            return null ;
        }
        return queue.removeFirst() ;
    }
    
    public synchronized int size() {
        return queue.size() ;
    }
}
