package org.maachang.session.client.local ;

import org.maachang.dbm.MDbm;
import org.maachang.dbm.MDbmIO;
import org.maachang.session.client.PSessionManager;
import org.maachang.session.engine.PersistenceEngine;
import org.maachang.session.engine.PersistenceService;

/**
 * ローカル接続による、
 * クライアント永続化セッションドライバ.
 * 
 * @version 2008/05/25
 * @author masahito suzuki
 * @since PersistenceSession 1.00
 */
public class PSessionLocalDriver {
    
    /**
     * 永続化セッションマネージャを取得.
     * @return PSessionManager 永続化セッションマネージャが返されます.
     * @exception Exception 例外.
     */
    public static final PSessionManager getConnection() throws Exception {
        return getConnection( null ) ;
    }
    
    /**
     * 永続化セッションマネージャを取得.
     * @param mdbm 対象のMDBMオブジェクトを設定します.
     * @return PSessionManager 永続化セッションマネージャが返されます.
     * @exception Exception 例外.
     */
    public static final PSessionManager getConnection( MDbm mdbm ) throws Exception {
        if( mdbm != null && ( mdbm instanceof MDbmIO ) == false ) {
            mdbm = mdbm.getParent() ;
        }
        if( mdbm == null ) {
            PersistenceService.getInstance().init() ;
        }
        else {
            PersistenceService.getInstance().init( mdbm ) ;
        }
        PersistenceEngine engine = PersistenceService.getInstance().getEngine() ;
        return new PSessionLocalManagerImpl( engine ) ;
    }
}

