package org.maachang.session.server.protocol ;

import org.maachang.util.ArrayBinary;
import org.maachang.util.ConvertParam;

/**
 * セッションID削除要求.
 * 
 * @version 2008/05/25
 * @author masahito suzuki
 * @since PersistenceSession 1.00
 */
public class SvDeleteSessionIdProtocol extends ServerProtocol {
    
    /**
     * 削除セッションID.
     */
    private String sessionId = null ;
    
    /**
     * コンストラクタ.
     */
    public SvDeleteSessionIdProtocol( byte[] bin,int p )
        throws Exception {
        int len = ConvertParam.convertInt( p,bin ) ;
        p += 4 ;
        if( len > 0 ) {
            byte[] b = new byte[ len ] ;
            System.arraycopy( bin,p,b,0,len ) ;
            this.sessionId = new String( b,"UTF8" ) ;
            p += len ;
        }
    }
    
    /**
     * サーバプロトコルタイプを取得.
     * @return int サーバプロトコルタイプが返されます.
     */
    public int getProtocolType() {
        return TYPE_DELETE_SESSION_ID ;
    }
    
    /**
     * 削除セッションIDを取得.
     * @return String 削除セッションIDが返されます.
     */
    public String getSessionId() {
        return sessionId ;
    }
    
    /**
     * 処理結果の内容を設定.
     * @param value 処理結果の内容を設定します.
     * @exception Exception 例外.
     */
    public void setResult( Object value ) throws Exception {
        ArrayBinary b = new ArrayBinary( 8 ) ;
        b.write( ConvertParam.convertInt( getProtocolType() ) ) ;
        this.result = b.getBinary() ;
    }
}

