// Microsoft専用HTA用JavaScript.
//

// グローバル.
var __VAL_GLOVAL__ = this ;

// IE判別.
var isMSIE = /*@cc_on!@*/false; 

// getElementById.
$ = function( name ) {
    return document.getElementById( name ) ;
} ;

// 基本API.
$base = {
    // nullチェック.
    isNull : function( value ) {
        if( value == null || typeof( value ) == "undefined" ) {
            return true ;
        }
        return false ;
    },
    // trim.
    trim : function(arg_value){
        if( this.isNull( arg_value ) == true ||
            arg_value.length <= 0 ) {
            return '' ;
        }
        else if( typeof( arg_value ) != "string" ) {
            return arg_value ;
        }
        for( i = 0; i < arg_value.length ; i ++ ) {
            var old = arg_value ;
            arg_value = arg_value.replace( "&nbsp;"," " ) ;
            if( old.length == arg_value.length ) {
                break ;
            }
        }
        
        var st = 0 ;
        var ed = arg_value.length ;
        var len = arg_value.length ;
        for( i = 0 ; i < len ; i ++ ) {
            var c = arg_value.charAt( i ) ;
            var x = arg_value.charCodeAt( i ) ;
            if( c == ' ' || c == '　' || c == '\t' || x == 160 ) {//x==160はsafari対応.
                st = i+1 ;
            }
            else {
                break ;
            }
        }
        len = arg_value.length-1 ;
        for( i = len ; i >= 0 ; i -- ) {
            var c = arg_value.charAt( i ) ;
            var x = arg_value.charCodeAt( i ) ;
            if( c == ' ' || c == '　' || c == '\t' || x == 160 ) {//x==160はsafari対応.
                ed = i ;
            }
            else {
                break ;
            }
        }
        if( st >= ed ) {
            return '' ;
        }
        ret = arg_value.substring( 0,ed ) ;
        if( st > 0 ) {
            ret = ret.substring( st ) ;
        }
        return ret ;
    },
    // 文字列を置き換える.
    changeString : function( base,src,dest ) {
        if( this.isNull( base ) ||
            this.isNull( src ) ||
            this.isNull( dest ) ) {
            return "" ;
        }
        // すべての文字列を置き換えるように変更.
        for( ;; ) {
            var ret = '' ;
            var p = base.indexOf( src ) ;
            if( p == -1 ) {
                return base ;
            }
            if( p == 0 ) {
                ret += dest ;
                ret += base.substring( src.length,base.length ) ;
            }
            else {
                ret += base.substring( 0,p ) ;
                ret += dest ;
                if( src.length != base.length ) {
                    ret += base.substring( p+src.length,base.length ) ;
                }
            }
            base = ret ;
            ret = "" ;
        }
    },
    // startWith.
    startsWith : function(str,chk) {
        if( this.isNull( str ) || this.isNull( chk ) ) {
            return false ;
        }
        str = ""+str ;
        chk = ""+chk ;
        if( str.indexOf( chk ) == 0 ) {
            return true ;
        }
        return false ;
    },
    // endsWith.
    endsWith : function(str,chk) {
        if( this.isNull( str ) || this.isNull( chk ) ) {
            return false ;
        }
        str = ""+str ;
        chk = ""+chk ;
        var last = str.lastIndexOf( chk ) ;
        if( last != -1 && last == str.length-chk.length ) {
            return true ;
        }
        return false ;
    },
    // 文字存在チェック.
    useString : function(str){
        if( this.isNull( str ) == true || this.trim(str).length <= 0 ) {
            return false ;
        }
        return true ;
    },
    // 数値チェック.
    isNumeric : function(num){
        if( this.useString( num ) == false ) {
            return false ;
        }
        if( this.startsWith( num,"-" ) ) {
            num = num.substring( 1 ) ;
        }
        if (num.match(/[^0-9.0-9]/g)) {
            return false;
        }
        return true;
    },
    // 文字をエンコード.
    encodeParam : function(params) {
        if( this.useString( params ) == true ) {
            return encodeURIComponent( params ) ;
        }
        return "" ;
    }
} ;

$json = function(){}
$json = {
    // json形式に変換.
    encode : function( value ) {
        if( $base.isNull( value ) ) {
            return "[\"\"]" ;
        }
        var t = valueof( value ) ;
        if( t == "array" ) {
            t = null ;
            var ret = "" ;
            ret = this.evalByArrayString( ret,value ) ;
            return ret ;
        }
        else if( t == "map" ) {
            t = null ;
            var ret = "[" ;
            this.evalByMapString( ret,value ) ;
            return ret + "]" ;
        }
        return "["+this.evalByString( t,value )+"]" ;
    },
    // json形式の文字列を変換.
    decode : function( value ) {
        if( $base.isNull( value ) || typeof( value ) != "string" ) {
            return null ;
        }
        var ret = eval( value ) ;
        if( $base.isNull( ret ) != null ) {
            if( this.valueof( ret ) == "array" && ret.length == 1 ) {
                ret = ret[ 0 ] ;
            }
            return ret ;
        }
        return null ;
    },
    // Arrayタイプから、eval実行可能内容を生成.
    evalByArrayString : function( o,v ) {
        o += "[" ;
        var len = v.length ;
        for( var i = 0 ; i < len ; i ++ ) {
            if( i != 0 ) {
                o += "," ;
            }
            var t = this.valueof( v[i] ) ;
            if( t == "array" ) {
                o = this.evalByArrayString( o,v[i] ) ;
            }
            else if( t == "map" ) {
                o = this.evalByMapString( o,v[i] ) ;
            }
            else {
                o += this.evalByString( t,v[i] ) ;
            }
        }
        return o + "]" ;
    },
    // Mapタイプから、eval実行可能内容を生成.
    evalByMapString : function( o,v ) {
        o += "{" ;
        var cnt = 0 ;
        for( var k in v ) {
            if( cnt != 0 ) {
                o += "," ;
            }
            o += "\"" + k + "\":" ;
            var t = this.valueof( v[k] ) ;
            if( t == "array" ) {
                o = this.evalByArrayString( o,v[k] ) ;
            }
            else if( t == "map" ) {
                o = this.evalByMapString( o,v[k] ) ;
            }
            else {
                o += this.evalByString( t,v[k] ) ;
            }
            cnt ++ ;
        }
        return o + "}" ;
    },
    // 指定タイプから、eval実行可能内容を生成.
    evalByString : function( t,v ) {
        if( t == "string" ) {
            return "\""+v+"\"" ;
        }
        else if( t == "boolean" ) {
            return ""+v ;
        }
        else if( t == "number" ) {
            return ""+v ;
        }
        else if( t == "date" ) {
            return "new Date(" + v.getTime() + ")" ;
        }
        return "\"\"" ;
    },
    // 指定内容タイプを取得.
    valueof : function( val ) {
        if( $base.isNull( val ) ) {
            return "null" ;
        }
        var t = typeof( val ) ;
        if( t == "string" ) {
            return "string" ;
        }
        if( t == "boolean" ) {
            return "boolean" ;
        }
        else if( t == "number" ) {
            return "number" ;
        }
        else if( t == "function" ) {
            return "function" ;
        }
        else if( t == "object" ) {
            if( val instanceof Date ) {
                return "date" ;
            }
            else if( val instanceof Array ) {
                if( val.length == 0 ) {
                    return "array" ;
                }
                return this.arrayOrMapValueTo( val ) ;
            }
        }
        return this.arrayOrMapValueTo( val ) ;
    },
    // 指定内容タイプがArrayかMapか取得.
    arrayOrMapValueTo : function( val ) {
        if( typeof( val.length ) == "number" ) {
            return "array" ;
        }
        for( var k in val ) {
            return "map" ;
        }
        return "object" ;
    }
} ;

// typeof拡張.
var valueof = function(value) {
    return $json.valueof(value) ;
} ;

// 先頭の空白を削除
String.prototype.ltrim = function() {
  return this.replace(/^\s+/, "");
}
// 末尾の空白を削除
String.prototype.rtrim = function() {
  return this.replace(/\s+$/, "");
}
// 先頭および末尾の空白を削除
String.prototype.trim = function() {
  return this.replace(/^\s+|\s+$/g, "");
}

// IE以外のブラウザアクセスチェック.
isIE = function() {
    if( isMSIE == false ) {
        alert( "IE以外では利用できません" ) ;
        return false ;
    }
    return true ;
}

// ローカルI/Oオブジェクト.
LocalIO = function() {} ;
LocalIO.READ = 1 ;
LocalIO.WRITE = 2 ;
LocalIO.APPEND = 8 ;
LocalIO._changeString = function( base,src,dest ) {
    for( ;; ) {
        var ret = '' ;
        var p = base.indexOf( src ) ;
        if( p == -1 ) {
            return base ;
        }
        if( p == 0 ) {
            ret += dest ;
            ret += base.substring( src.length,base.length ) ;
        }
        else {
            ret += base.substring( 0,p ) ;
            ret += dest ;
            if( src.length != base.length ) {
                ret += base.substring( p+src.length,base.length ) ;
            }
        }
        base = ret ;
        ret = "" ;
    }
}
LocalIO.isFile = function( name ) {
    if( !isIE() ) {
        return false ;
    }
    if( name.indexOf( ".." ) != -1 || name.indexOf( ":" ) != -1 ) {
        alert( "不正なファイル名[" + naem + "]が指定されています" ) ;
    }
    name = LocalIO._changeString( name,"/","\\" ) ;
    if( name.indexOf( "\\" ) == 0 ) {
        name = name.substring( 1 ) ;
    }
    name = "c:\\._$ie_$save_$\\" + name ;
    var f = new ActiveXObject("Scripting.FileSystemObject");
    if( f.FolderExists( "c:\\._$ie_$save_$" ) == false ) {
        f.CreateFolder( "c:\\._$ie_$save_$" ) ;
    }
    var ret = f.FileExists( name ) ;
    f = null ;
    return ret ;
}

LocalIO.prototype = {
    fp : null,
    fileName : null,
    openRead : function( name ) {
        return this.open( LocalIO.READ,name ) ;
    },
    openWrite : function( name ) {
        return this.open( LocalIO.WRITE,name ) ;
    },
    openAppend : function( name ) {
        return this.open( LocalIO.APPEND,name ) ;
    },
    open : function( mode,name ) {
        if( !isIE() ) {
            return false ;
        }
        if( name.indexOf( ".." ) != -1 || name.indexOf( ":" ) != -1 ) {
            alert( "不正なファイル名[" + naem + "]が指定されています" ) ;
        }
        if( mode == LocalIO.READ ) {
            if( LocalIO.isFile( name ) == false ) {
                alert( "読み込み対象のファイルは存在しません" ) ;
                return false ;
            }
        }
        name = LocalIO._changeString( name,"/","\\" ) ;
        if( name.indexOf( "\\" ) == 0 ) {
            name = name.substring( 1 ) ;
        }
        var f = new ActiveXObject( "Scripting.FileSystemObject" ) ;
        if( f.FolderExists( "c:\\._$ie_$save_$" ) == false ) {
            f.CreateFolder( "c:\\._$ie_$save_$" ) ;
        }
        var tName = name ;
        name = "C:\\._$ie_$save_$\\" + name ;
        if( mode == LocalIO.APPEND ) {
            if( f.FileExists( name ) == false ) {
                mode = LocalIO.WRITE ;
            }
        }
        this.fp = f.OpenTextFile(name,mode,true ) ;
        this.fileName = tName ;
        f = null ;
    },
    clear : function() {
        if( !isIE() ) {
            return false ;
        }
        if( this.fp != null ) {
            return false ;
        }
        var name = fileName ;
        this.close() ;
        this.open( LocalIO.WRITE,name ) ;
        this.close() ;
        return true ;
    },
    close : function() {
        if( !isIE() ) {
            return false ;
        }
        if( this.fp != null ) {
            this.fp.close() ;
        }
        this.fp = null ;
        this.fileName = null ;
        return true ;
    },
    readLine : function() {
        if( !isIE() ) {
            return null ;
        }
        if( this.fp == null ) {
            return null ;
        }
        if( this.fp.AtEndOfLine ) {
            return null ;
        }
        var ret = this.fp.readLine() ;
        return ret ;
    },
    writeLine : function( value ) {
        if( !isIE() ) {
            return false ;
        }
        if( this.fp == null ) {
            return false ;
        }
        this.fp.writeLine( value ) ;
        return true ;
    },
    fileName : function() {
        if( !isIE() ) {
            return null ;
        }
        if( this.fp == null ) {
            return null ;
        }
        return this.fileName ;
    }
}

// Ajaxアクセス.
var accessAjax = function( url,params,callFunc ) {
    if( !isIE() ) {
        return "" ;
    }
    // Ajaxオブジェクトを生成.
    var xmlhttp = null ;
    if(window.ActiveXObject) {
        try {
            xmlhttp = new ActiveXObject("Msxml2.XMLHTTP");
        } catch (e) {
            xmlhttp = null ;
        }
        if( $base.isNull( xmlhttp ) ) {
            try {
                xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
            } catch (e) {
                xmlhttp = null;
            }
        }
    }
    var sync = ( $base.isNull( callFunc ) ) ? "false" : "true" ;
    if( $base.isNull( xmlhttp ) ) {
        if( sync ) {
            callFunc( "" ) ;
            return "" ;
        }
        return "" ;
    }
    
    // パラメータが存在する場合.
    if( $base.isNull( params ) == false && valueof( params ) == "array" ) {
        // コネクション[POST]オープン.
        xmlhttp.open("POST",url,sync);
        
        // POST用ContentTypeをセット.
        try {
            if( typeof( xmlhttp.setRequestHeader ) == 'function' ) {
                xmlhttp.setRequestHeader( "Content-Type",
                    "application/x-www-form-urlencoded; charset=UTF-8" ) ;
            }
        } catch( e ) {
        }
    }
    else {
        // コネクション[GET]オープン.
        xmlhttp.open("GET",url,sync) ;
        params = null ;
    }
    
    // 非同期処理の場合.
    if( sync == "true" ) {
        xmlhttp.onreadystatechange = function() {
            if( xmlhttp.readyState == 4 ) {
                try {
                    // 正常処理.
                    if( xmlhttp.status == 200 ) {
                        var result = xmlhttp.responseText ;
                        callFunc( result ) ;
                    }
                } catch( e ) {
                    // エラー処理.
                    alert( "接続エラーを検知" ) ;
                }
                // 接続処理終了.
                try {
                    xmlhttp.abort() ;
                } catch( e ) {
                }
                xmlhttp = null ;
            }
        }
    }
    // 送信パラメータを生成.
    var sndPm ;
    if( $base.isNull( params ) == false ) {
        sndPm = "" ;
        for( var i = 0 ; i < len ; i += 2 ) {
            if( i != 0 ) {
                sndPm += "&" ;
            }
            sndPm = sndPm + params[ i ] + "=" + $base.encodeParam( params[ i+1 ] ) ;
        }
    }
    else {
        sndPm = null ;
    }
    
    // 送信処理.
    xmlhttp.send( sndPm ) ;
    
    // 同期処理の場合.
    if( sync == "false" ) {
        var result = xmlhttp.responseText ;
        // 接続処理終了.
        try {
            xmlhttp.abort() ;
        } catch( e ) {
        }
        xmlhttp = null ;
        return result ;
    }
    return "" ;
} ;

