// init@CI/O.

#ifndef _INI_FILE_H_INCLUDE_
#define _INI_FILE_H_INCLUDE_

#include "fileio.h"

// fBtHg̎sl.
#define DEFAULT_NOTHING_STRING "_DEFAULT_NOTHING_STRING"
#define DEFAULT_NOTHING_NUMBER -99999999

#define MAX_NUMBER_LENGTH 260

// INIt@CI/ONX.
class CIni
{
private :
    
    // t@Ci[.
    char m_name[ MAX_PATH+1 ] ;
    
public :
    
    //----------------------------------------------------------------------------//
    // RXgN^.
    //----------------------------------------------------------------------------//
    CIni() {
        this->clear() ;
    }
    //----------------------------------------------------------------------------//
    // fXgN^.
    //----------------------------------------------------------------------------//
    ~CIni() {
        this->clear() ;
    }
    
public :
    
    //------------------------------------------------------------------------------
    // ΏۂINIt@Cݒ.
    //------------------------------------------------------------------------------
    BOOL create( char* fileName )
    {
        if( fileName == NULL || strlen( fileName ) <= 0 ){
            return FALSE ;
        }
        if( isFileOrDir( fileName,NULL ) != 1 ) {
            return FALSE ;
        }
        this->clear() ;
        sprintf( m_name,"%s\0",fileName ) ;
        return TRUE ;
    }

    //------------------------------------------------------------------------------
    // NA.
    //------------------------------------------------------------------------------
    void clear()
    {
        memset( m_name,'\0',MAX_PATH+1 ) ;
    }

    //------------------------------------------------------------------------------
    // Ώۂ̏擾.
    //------------------------------------------------------------------------------
    BOOL get( char* out,int length,const char* section,const char* key )
    {
        int chk ;
        BOOL ret ;
        
        ret = FALSE ;
        
        if( out == NULL || length <= 0 || section == NULL || key == NULL ){
            return FALSE ;
        }
        
        memset( out,'\0',length ) ;
        memcpy( out,DEFAULT_NOTHING_STRING,strlen( DEFAULT_NOTHING_STRING ) ) ;
        
        chk = ::GetPrivateProfileString(
            section,key,DEFAULT_NOTHING_STRING,out,length,m_name
        ) ;
        
        if( chk > 0 ){
            if( strcmp( out,DEFAULT_NOTHING_STRING ) != 0 ){
                ret = TRUE ;
            }
        }
        
        return ret ;
    }

    //------------------------------------------------------------------------------
    // Ώۂ̏擾.
    //------------------------------------------------------------------------------
    BOOL get( int* out,const char* section,const char* key )
    {
        BOOL ret ;
        
        ret = FALSE ;
        
        if( out == NULL || section == NULL || key == NULL ){
            return FALSE ;
        }
        
        *out = DEFAULT_NOTHING_NUMBER ;
        
        *out = ::GetPrivateProfileInt(
            section,key,DEFAULT_NOTHING_NUMBER,m_name
        ) ;
        
        if( *out != DEFAULT_NOTHING_NUMBER ){
            ret = TRUE ;
        }
        
        return ret ;
    }

    //------------------------------------------------------------------------------
    // Ώۂ̏ݒ.
    //------------------------------------------------------------------------------
    BOOL put( char* in,const char* section,const char* key )
    {
        int chk ;
        BOOL ret ;
        
        ret = FALSE ;
        
        if( in == NULL || section == NULL || key == NULL ){
            return FALSE ;
        }
        
        chk = ::WritePrivateProfileString(
            section,key,in,m_name
        ) ;
        
        if( chk != 0 ){
            ret = TRUE ;
        }
        
        return ret ;
    }

    //------------------------------------------------------------------------------
    // Ώۂ̏ݒ.
    //------------------------------------------------------------------------------
    BOOL put( int in,const char* section,const char* key )
    {
        int chk ;
        BOOL ret ;
        char inp[ MAX_NUMBER_LENGTH+1 ] ;
        
        ret = FALSE ;
        
        if( in == NULL || section == NULL || key == NULL ){
            return FALSE ;
        }
        
        memset( inp,'\0',MAX_NUMBER_LENGTH+1 ) ;
        sprintf( inp,"%d\0",in ) ;
        
        chk = ::WritePrivateProfileString(
            section,key,inp,m_name
        ) ;
        
        if( chk != 0 ){
            ret = TRUE ;
        }
        
        return ret ;
    }
    
} ;

#endif // _INI_FILE_H_INCLUDE_
