// [eBeBn.

#ifndef _UTIL_H_INCLUDE_
#define _UTIL_H_INCLUDE_

#include <windows.h>
#include <stdlib.h>
#include <stdio.h>

#include <direct.h>
#include <process.h>

// CSV.
typedef struct _csvLink{
    struct _csvLink* next ;
    char data[ 64 ] ;
} CSV,*LPCSV ;

// bZ[W{bNX.
inline alert( const char* message ) {
    MessageBox(NULL,TEXT(message),"execHTA",MB_OK ) ;
}

// wϐ擾.
inline void getENV( char* out,char* name ) {
    char* c = getenv( name ) ;
    out[ 0 ] = '\0' ;
    if( c != NULL && strlen( c ) > 0 ) {
        sprintf( out,"%s\0",c ) ;
    }
}

// wϐ擾.
inline char* getENV( char* name ) {
    return getenv( name ) ;
}


// A.
inline void joinString( char* out,char* src,char* join ) {
    sprintf( out,"%s%s\0",src,join ) ;
}

// A(static).
static char __js_s[ 32767 ] ;
inline char* joinString_s( char* src,char* join ) {
    memset( __js_s,0,32767 ) ;
    sprintf( __js_s,"%s%s\0",src,join ) ;
    return __js_s ;
}

// IndexOf.
inline int indexOf( const char* string,const char* check,int index ) {
    if( index <= 0 ) {
        index = 0 ;
    }
    int len = strlen( string ) ;
    int checkLen = strlen( check ) ;
    int pnt = 0 ;
    int ret = -1 ;
    for( int i = index ; i < len ; i ++ ) {
        if( pnt == 0 ) {
            if( string[ i ] == check[ 0 ] ) {
                pnt = 1 ;
                ret = i ;
                if( pnt >= checkLen ) {
                    return ret ;
                }
                continue ;
            }
        }
        else {
            if( string[ i ] == check[ pnt ] ) {
                pnt ++ ;
                if( pnt >= checkLen ) {
                    return ret ;
                }
            }
            else {
                pnt = 0 ;
                ret = -1 ;
            }
        }
    }
    return -1 ;
}

// LastIndexOf.
inline int lastIndexOf( const char* string,const char* check,int index ) {
    int len = strlen( string ) ;
    if( index <= 0 || len <= index ) {
        index = len-1 ;
    }
    int checkLen = strlen( check ) ;
    int pnt = 0 ;
    int ret = -1 ;
    for( int i = index ; i >= 0 ; i -- ) {
        if( pnt == 0 ) {
            if( string[ i ] == check[ 0 ] ) {
                pnt = 1 ;
                ret = i ;
                if( pnt >= checkLen ) {
                    return ret ;
                }
                continue ;
            }
        }
        else {
            if( string[ i ] == check[ pnt ] ) {
                pnt ++ ;
                if( pnt >= checkLen ) {
                    return ret ;
                }
            }
            else {
                pnt = 0 ;
                ret = -1 ;
            }
        }
    }
    return -1 ;
}

// StartsWith.
inline BOOL startsWith( const char* string,const char* check ) {
    int len = strlen( string ) ;
    int checkLen = strlen( check ) ;
    if( checkLen > len ) {
        return FALSE ;
    }
    for( int i = 0 ; i < checkLen ; i ++ ) {
        if( string[ i ] != check[ i ] ) {
            return FALSE ;
        }
    }
    return TRUE ;
}

// EndsWith.
inline BOOL endsWith( const char* string,const char* check ) {
    int len = strlen( string ) ;
    int checkLen = strlen( check ) ;
    if( checkLen > len ) {
        return FALSE ;
    }
    for( int i = len - checkLen,j = 0 ; i < len ; i ++,j ++ ) {
        if( string[ i ] != check[ j ] ) {
            return FALSE ;
        }
    }
    return TRUE ;
}

// substring.
inline BOOL subString( char* out,const char* string,int start,int end ) {
    if( string == NULL ) {
        return FALSE ;
    }
    int len = strlen( string ) ;
    if( start <= 0 ) {
        start = 0 ;
    }
    if( end <= 0 ) {
        end = len-start ;
    }
    int lenI = end - start ;
    for( int i = 0 ; i < lenI ; i ++ ) {
        out[ i ] = string[ i+start ] ;
    }
    out[ lenI ] = '\0' ;
    return TRUE ;
}

// toLowerCase.
inline BOOL toLowerCase( char* out,char* name ) {
    if( out == NULL || name == NULL ) {
        return FALSE ;
    }
    int len = strlen( name ) ;
    for( int i = 0 ; i < len ; i ++ ) {
        if( name[ i ] >= 'A' && name[ i ] <= 'Z' ) {
            out[ i ] = 'a' + ( name[ i ] - 'A' ) ;
        }
        else {
            out[ i ] = name[ i ] ;
        }
    }
    out[ len ] = '\0' ;
    return TRUE ;
}

// toUpperCase.
inline BOOL toUpperCase( char* out,char* name ) {
    if( out == NULL || name == NULL ) {
        return FALSE ;
    }
    int len = strlen( name ) ;
    for( int i = 0 ; i < len ; i ++ ) {
        if( name[ i ] >= 'a' && name[ i ] <= 'z' ) {
            out[ i ] = 'A' + ( name[ i ] - 'a' ) ;
        }
        else {
            out[ i ] = name[ i ] ;
        }
    }
    out[ len ] = '\0' ;
    return TRUE ;
}


// vZXNfBNg擾.
static char __currentDir[ 261 ] ;
static BOOL __isCurrentDir = FALSE ;
inline char* getCurrentPath() {
    if( __isCurrentDir ) {
        return __currentDir ;
    }
    GetModuleFileName(NULL, __currentDir, 261) ;
    int e = lastIndexOf( __currentDir,"\\",-1 ) ;
    if( e != -1 ) {
        subString( __currentDir,__currentDir,0,e ) ;
    }
    __isCurrentDir = TRUE ;
    return __currentDir ;
}

// vWFNgfBNgpX擾.
inline BOOL getProjectPath( char* out ) {
    if( out == NULL ) {
        return FALSE ;
    }
    char* c = getCurrentPath() ;
    //int e = lastIndexOf( c,"\\",-1 ) ;
    //subString( out,c,0,e ) ;
    sprintf( out,"%s\0",c ) ;
    return TRUE ;
}

// R}hs.
inline int execCmd( const char* path,
    const char* execPath,
    const char* execName,
    const char* args ) {
    // s.
    if( path != NULL ) {
        _chdir( path ) ;
    }
    return _spawnlp( _P_NOWAIT,execPath,execName,args,NULL ) ;
}

// 1sCSV擾.
inline LPCSV csvToLine( const char* string,const char* cut ) {
    LPCSV ret = NULL ;
    LPCSV now = NULL ;
    int p,p2 ;
    int len ;
    len = strlen( string ) ;
    if( len == 0 ) {
        return NULL ;
    }
    p = indexOf( string,cut,0 ) ;
    if( p == -1 ) {
        return NULL ;
    }
    ret = ( LPCSV )malloc( sizeof( CSV ) ) ;
    subString( ret->data,string,0,p ) ;
    ret->next = NULL ;
    now = ret ;
    p2 = p+1 ;
    for( ;; ) {
        p = indexOf( string,cut,p2 ) ;
        if( p == -1 ) {
            if( p2 >= len ) {
                break ;
            }
            now->next = ( LPCSV )malloc( sizeof( CSV ) ) ;
            now = now->next ;
            now->next = NULL ;
            subString( now->data,string,p2,len ) ;
            break ;
        }
        
        if( p == p2 ) {
            now->next = ( LPCSV )malloc( sizeof( CSV ) ) ;
            now = now->next ;
            now->data[ 0 ] = '\0' ;
            now->next = NULL ;
        }
        else {
            now->next = ( LPCSV )malloc( sizeof( CSV ) ) ;
            now = now->next ;
            now->next = NULL ;
            subString( now->data,string,p2,p ) ;
        }
        p2 = p+1 ;
    }
    return ret ;
}

// 1sCSVj.
inline void destroyCSV( LPCSV csv ) {
    LPCSV now ;
    if( csv == NULL ) {
        return ;
    }
    for( ;; ) {
        now = csv->next ;
        free( csv ) ;
        if( now == NULL ) {
            break ;
        }
        csv = now ;
    }
}

// CSVJbg擾.
inline int csvLength( LPCSV csv ) {
    int cnt ;
    LPCSV now ;
    if( csv == NULL ) {
        return 0 ;
    }
    for( cnt = 1 ;; ) {
        now = csv->next ;
        if( now == NULL ) {
            break ;
        }
        csv = now ;
        cnt ++ ;
    }
    return cnt ;
}

#endif // _UTIL_H_INCLUDE_
