/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.report;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.maachang.report.CellPosition;
import org.maachang.report.CellStyle;
import org.maachang.report.CellStyleList;

class CellPositionList {
    private Map<String, CellPosition[]> map = null;
    private CellStyleList csList = null;

    private CellPositionList() {
    }

    public CellPositionList(CellStyleList csList) {
        this.map = new HashMap<String, CellPosition[]>();
        this.csList = csList;
    }

    public void clear() {
        this.map.clear();
    }

    private void pushCellStyle(CellPosition pos) {
        if (this.csList == null || this.csList.size() <= 0) {
            return;
        }
        pos.setCellStyleName(null);
        Iterator it = this.csList.iterator();
        while (it.hasNext()) {
            String k = (String)it.next();
            CellStyle cs = this.csList.get(k);
            if (cs == null || !cs.isGroup(pos.getX(), pos.getY())) continue;
            pos.setCellStyleName(cs.getName());
            break;
        }
    }

    public void put(CellPosition pos) {
        if (pos == null) {
            return;
        }
        String k = pos.getName();
        this.pushCellStyle(pos);
        if (pos.getCellStyleName() != null) {
            this.map.put(k, new CellPosition[]{pos});
        } else {
            CellPosition[] bef = this.map.get(k);
            if (bef != null && bef[0].getCellStyleName() == null) {
                int len = bef.length;
                CellPosition[] nw = new CellPosition[len + 1];
                System.arraycopy(bef, 0, nw, 0, len);
                nw[len] = pos;
                this.map.put(k, nw);
                bef = null;
            } else {
                this.map.put(k, new CellPosition[]{pos});
            }
        }
    }

    public CellPosition[] get(String name) {
        if (name == null || (name = name.trim()).length() <= 0) {
            return null;
        }
        return this.map.get(name);
    }

    public int size() {
        return this.map.size();
    }

    public Iterator iterator() {
        return this.map.keySet().iterator();
    }

    public CellPosition getSequence(String name) {
        if (name == null || (name = name.trim()).length() <= 0) {
            return null;
        }
        for (String key : this.map.keySet()) {
            CellPosition[] p;
            if (!key.startsWith("seq:") || (p = this.map.get(key)) == null) continue;
            int len = p.length;
            int i = 0;
            while (i < len) {
                if (name.equals(p[i].getCellStyleName())) {
                    return p[i];
                }
                ++i;
            }
        }
        return null;
    }

    public String toString() {
        if (this.map.size() <= 0) {
            return "\u306a\u3057";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("[CellPosition] ->");
        for (String s : this.map.keySet()) {
            CellPosition[] lst = this.map.get(s);
            buf.append(" name:").append(s);
            int len = lst.length;
            buf.append("(").append(len).append(")=>");
            int i = 0;
            while (i < len) {
                buf.append(" #").append(i + 1).append("#").append(lst[i].toString());
                ++i;
            }
        }
        return buf.toString();
    }
}

