/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dao;

import org.maachang.dao.DaoSession;
import org.maachang.dao.MaachangDaoException;
import org.maachang.dao.dbms.Record;
import org.maachang.dao.dbms.RecordFactory;
import org.maachang.dao.dbms.RecordSequenceId;
import org.maachang.util.FileUtil;

public class DaoSessionFactory {
    private static final String OUTPUT_SEQ_DIR = "./conf/jseq/";
    private static final String SEQ_FILE = "jseq.seq";
    private static final String SEQ_META_FILE = "jseq.meta";
    private static final DaoSessionFactory SNGL = new DaoSessionFactory();
    private RecordFactory recordFactory = null;
    private DaoSession[] daoSessions = null;
    private RecordSequenceId javaSeq = null;
    private final Object javaSeqSync = new Object();

    private DaoSessionFactory() {
    }

    public static final DaoSessionFactory getInstance() {
        return SNGL;
    }

    protected synchronized void setRecordFactory(RecordFactory recordFactory) {
        this.recordFactory = recordFactory;
        int len = recordFactory.getConnectionManager().getMax();
        this.daoSessions = new DaoSession[len];
        int i = 0;
        while (i < len) {
            this.daoSessions[i] = new DaoSession();
            ++i;
        }
    }

    public synchronized RecordFactory getRecordFactory() {
        return this.recordFactory;
    }

    public DaoSession getDaoSession() throws MaachangDaoException {
        if (this.recordFactory != null) {
            Record record = null;
            DaoSession ret = null;
            try {
                record = this.recordFactory.getRecord();
                ret = this.poolDaoSession(record);
            }
            catch (Exception e) {
                if (record != null) {
                    try {
                        record.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw new MaachangDaoException(e);
            }
            return ret;
        }
        throw new MaachangDaoException("\u521d\u671f\u5316\u3055\u308c\u3066\u3044\u306a\u3044\u304b\u3001\u6761\u4ef6\u304c\u4e0d\u6b63\u3067\u3059");
    }

    public DaoSession getDaoSession(Record record) throws MaachangDaoException {
        DaoSession s = this.poolDaoSession(record);
        return s;
    }

    public Record getRecord() throws MaachangDaoException {
        if (this.recordFactory != null) {
            Record ret = null;
            try {
                ret = this.recordFactory.getRecord();
            }
            catch (Exception e) {
                if (ret != null) {
                    try {
                        ret.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw new MaachangDaoException(e);
            }
            return ret;
        }
        throw new MaachangDaoException("\u521d\u671f\u5316\u3055\u308c\u3066\u3044\u306a\u3044\u304b\u3001\u6761\u4ef6\u304c\u4e0d\u6b63\u3067\u3059");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createJavaSequence() throws Exception {
        Object object = this.javaSeqSync;
        synchronized (object) {
            RecordSequenceId rs;
            if (this.javaSeq != null && this.javaSeq.isUse()) {
                return;
            }
            if (!FileUtil.isDirExists((String)OUTPUT_SEQ_DIR)) {
                FileUtil.mkdirs((String)OUTPUT_SEQ_DIR);
            }
            this.javaSeq = rs = new RecordSequenceId("./conf/jseq/jseq.seq", "./conf/jseq/jseq.meta");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearJavaSequence() {
        Object object = this.javaSeqSync;
        synchronized (object) {
            if (this.javaSeq != null) {
                this.javaSeq.destroy();
            }
            this.javaSeq = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteJavaSequence() {
        Object object = this.javaSeqSync;
        synchronized (object) {
            if (this.javaSeq != null) {
                try {
                    this.javaSeq.allClear();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.javaSeq.destroy();
            }
            this.javaSeq = null;
            try {
                FileUtil.removeFile((String)"./conf/jseq/jseq.meta");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordSequenceId getJavaSequence() {
        RecordSequenceId ret;
        Object object = this.javaSeqSync;
        synchronized (object) {
            ret = this.javaSeq;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJavaSequence() {
        boolean ret;
        Object object = this.javaSeqSync;
        synchronized (object) {
            ret = this.javaSeq != null;
        }
        return ret;
    }

    private synchronized DaoSession poolDaoSession(Record record) {
        int len = this.daoSessions.length;
        int i = 0;
        while (i < len) {
            DaoSession s = this.daoSessions[i];
            if (!s.isUsedObject()) {
                s.create(record);
                return s;
            }
            ++i;
        }
        return new DaoSession();
    }
}

