/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dao.dbms;

import java.sql.ResultSetMetaData;
import org.maachang.dao.dbms.ColumnChild;
import org.maachang.dao.dbms.DbUtil;

public class MetaColumn {
    private String table = null;
    private ColumnChild[] columns = null;
    private Object object = null;

    private MetaColumn() {
    }

    public MetaColumn(String table, ResultSetMetaData meta) throws Exception {
        int len = meta.getColumnCount();
        if (table == null || table.trim().toLowerCase().length() <= 0 || len <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.table = table;
        this.columns = new ColumnChild[len];
        int i = 0;
        while (i < len) {
            int n = i + 1;
            this.columns[i] = new ColumnChild();
            this.columns[i].name = meta.getColumnName(n).trim().toLowerCase();
            this.columns[i].type = meta.getColumnType(n);
            ++i;
        }
    }

    public String getTable() {
        return this.table;
    }

    public String getColumnName(int no) {
        return this.getColumnName(false, no);
    }

    public String getColumnName(boolean mode, int no) {
        if (this.columns == null || no < 0 || no >= this.columns.length) {
            return null;
        }
        if (mode) {
            return DbUtil.convertDBNameByJavaName(false, this.columns[no].name);
        }
        return this.columns[no].name;
    }

    public int getColumnType(int no) {
        if (this.columns == null || no < 0 || no >= this.columns.length) {
            return -1;
        }
        return this.columns[no].type;
    }

    public int getColumnNameByNumber(String column) {
        return this.getColumnNameByNumber(false, column);
    }

    public int getColumnNameByNumber(boolean mode, String column) {
        if (this.columns == null || column == null || (column = column.trim().toLowerCase()).length() <= 0) {
            return -1;
        }
        if (mode) {
            column = DbUtil.convertJavaNameByDBName(column);
        }
        int len = this.columns.length;
        int i = 0;
        while (i < len) {
            if (column.equals(this.columns[i].name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int size() {
        if (this.columns == null) {
            return 0;
        }
        return this.columns.length;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public Object getObject() {
        return this.object;
    }

    public String toString() {
        if (this.columns == null) {
            return "null";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("table:").append(this.table);
        int len = this.columns.length;
        buf.append(" {");
        int i = 0;
        while (i < len) {
            buf.append(" [").append(i + 1).append("]");
            buf.append(" name:").append(this.columns[i].name);
            buf.append(" type:").append(this.columns[i].type);
            ++i;
        }
        buf.append(" }");
        return buf.toString();
    }
}

