/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.conf;

import org.maachang.comet.conf.UrlMask;

class UrlMaskList {
    private static final int ASCII = 128;
    private Object[] topList = null;
    private int length = 0;

    public UrlMaskList() {
        this.clear();
    }

    protected void finalize() throws Exception {
        this.topList = null;
    }

    public void clear() {
        this.topList = new Object[128];
        this.length = 0;
    }

    public void add(UrlMask mask) {
        String url = null;
        if (mask == null || (url = mask.getUrl()) == null || url.length() <= 1) {
            return;
        }
        int no = url.charAt(1) & 0x7F;
        UrlMask[] list = null;
        if (this.topList[no] == null) {
            this.topList[no] = list = new UrlMask[1];
            list[0] = mask;
            ++this.length;
        } else {
            int len = ((UrlMask[])this.topList[no]).length;
            list = new UrlMask[len + 1];
            System.arraycopy(this.topList[no], 0, list, 0, len);
            this.topList[no] = list;
            list[len] = mask;
            ++this.length;
        }
    }

    public boolean isMask(String url, String address) {
        if (url == null || url.length() <= 1) {
            return true;
        }
        if (!url.startsWith("/") || address == null || address.length() <= 0) {
            return false;
        }
        int no = url.charAt(1) & 0x7F;
        UrlMask[] list = (UrlMask[])this.topList[no];
        if (list == null) {
            return true;
        }
        int len = list.length;
        boolean ret = true;
        int i = 0;
        while (i < len) {
            UrlMask mk = list[i];
            if (mk.isUrl(url)) {
                if (mk.isMask(address)) {
                    return true;
                }
                ret = false;
            }
            ++i;
        }
        return ret;
    }

    public int size() {
        return this.length;
    }
}

