/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.cron;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.httpd.engine.script.cron.CronBean;
import org.maachang.comet.httpd.engine.script.cron.CronScript;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CronOneThread
extends Thread {
    private static final Log LOG = LogFactory.getLog(CronOneThread.class);
    private List<CronBean> executions = null;
    private CronBean bean = null;
    private volatile boolean stopFlag = true;
    private final Object sync = new Object();

    private CronOneThread() {
    }

    public CronOneThread(List<CronBean> executions, CronBean bean) throws Exception {
        if (executions == null || bean == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.executions = executions;
        this.bean = bean;
        this.setDaemon(true);
        this.stopFlag = true;
        this.executions.add(bean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStop() {
        boolean ret;
        Object object = this.sync;
        synchronized (object) {
            ret = this.stopFlag;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block25: {
            String scriptName = this.bean.getScript();
            Object object = this.sync;
            synchronized (object) {
                this.stopFlag = false;
            }
            try {
                try {
                    long time = System.currentTimeMillis();
                    LOG.info((Object)(">>Cron\u5b9f\u884c:[" + scriptName + "] - {" + this.bean.toString() + "}"));
                    CronScript.execution(scriptName);
                    time = System.currentTimeMillis() - time;
                    LOG.info((Object)(">>Cron\u5b9f\u884c\u7d42\u4e86:[" + scriptName + "] - {" + this.bean.toString() + "} - " + time + "msec"));
                }
                catch (Exception e) {
                    LOG.error((Object)(">>Cron\u5b9f\u884c\u30a8\u30e9\u30fc[" + scriptName + "] - {" + this.bean.toString() + "}"), (Throwable)e);
                }
                break block25;
            }
            catch (Throwable throwable) {
                try {
                    int len = this.executions.size();
                    int i = 0;
                    while (i < len) {
                        CronBean b = this.executions.get(i);
                        if (this.bean.equals(b)) {
                            this.executions.remove(i);
                        }
                        ++i;
                    }
                }
                catch (Exception len) {
                    // empty catch block
                }
            }
            try {
                this.bean.setLastExecutionTime(System.currentTimeMillis());
            }
            catch (Exception len) {
                // empty catch block
            }
            Object len = this.sync;
            synchronized (len) {
                this.stopFlag = true;
            }
            throw throwable;
        }
        try {
            int len = this.executions.size();
            int i = 0;
            while (i < len) {
                CronBean b = this.executions.get(i);
                if (this.bean.equals(b)) {
                    this.executions.remove(i);
                    break;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.bean.setLastExecutionTime(System.currentTimeMillis());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object object = this.sync;
        synchronized (object) {
            this.stopFlag = true;
        }
    }
}

