/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.dao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.httpd.engine.script.dao.DaoUtil;
import org.maachang.comet.httpd.engine.script.dao.JsResultLine;
import org.maachang.comet.httpd.engine.script.dao.ParseSql;
import org.maachang.comet.httpd.engine.script.image.ImageOp;
import org.maachang.dao.DaoSession;
import org.maachang.dao.DaoSessionFactory;
import org.maachang.dao.DeleteJoinPlugin;
import org.maachang.dao.MaachangDao;
import org.maachang.dao.MaachangDaoException;
import org.maachang.dao.OptimisticLockException;
import org.maachang.dao.ResultLine;
import org.maachang.dao.dbms.DbUtil;
import org.maachang.dao.dbms.MetaColumn;
import org.maachang.dao.dbms.MetaFactory;
import org.maachang.dao.dbms.Record;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dao {
    private static final String FD_COLUMN_ID = DbUtil.convertDBNameByJavaName((boolean)false, (String)"id");
    private static final String FD_COLUMN_CREATE_TIME = DbUtil.convertDBNameByJavaName((boolean)false, (String)"create_time");
    private static final String FD_COLUMN_UPDATE_TIME = DbUtil.convertDBNameByJavaName((boolean)false, (String)"update_time");
    private static final String FD_COLUMN_OPTIMISTIC_LOCK = DbUtil.convertDBNameByJavaName((boolean)false, (String)"optimistic_lock");
    private static final Log LOG = LogFactory.getLog(Dao.class);
    private String model = null;

    private Dao() {
    }

    public Dao(String model) throws Exception {
        if (model == null || (model = model.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.model = model;
    }

    public String getModel() {
        return this.model;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean save(Record record, Map<String, Object> data) throws MaachangDaoException {
        DaoSession session = null;
        try {
            session = this.getSession(record);
            Map map = this.convertBeanByJoin(data);
            map = this.convertInputMap(map);
            map = MaachangDao.getInstance().save(session, this.model, map);
            if (data.get(FD_COLUMN_ID) == null) {
                data.put(FD_COLUMN_ID, map.get(FD_COLUMN_ID));
            }
            if (map.get(FD_COLUMN_CREATE_TIME) != null) {
                data.put(FD_COLUMN_CREATE_TIME, map.get(FD_COLUMN_CREATE_TIME));
            }
            if (map.get(FD_COLUMN_UPDATE_TIME) != null) {
                data.put(FD_COLUMN_UPDATE_TIME, map.get(FD_COLUMN_UPDATE_TIME));
            }
            if (map.get(FD_COLUMN_OPTIMISTIC_LOCK) != null) {
                data.put(FD_COLUMN_OPTIMISTIC_LOCK, map.get(FD_COLUMN_OPTIMISTIC_LOCK));
            }
            session.clear();
            session = null;
            return true;
        }
        catch (OptimisticLockException ol) {
            LOG.warn((Object)"optimisticLockError", (Throwable)ol);
            if (session == null) return false;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            session.clear();
            return false;
            catch (MaachangDaoException md) {
                throw md;
                catch (Exception e) {
                    throw new MaachangDaoException(e);
                }
            }
        }
        finally {
            if (session != null) {
                session.clear();
            }
        }
    }

    public void update(Record record, String where, ArrayList<Object> params) throws MaachangDaoException {
        DaoSession session = null;
        try {
            try {
                session = this.getSession(record);
                ArrayList<String> sql = this.parseSql(where);
                Object[] pms = this.convertInputList(sql, params);
                where = this.srcSql(sql);
                MaachangDao.getInstance().update(session, this.model, where, pms);
                session.clear();
                session = null;
            }
            catch (MaachangDaoException md) {
                throw md;
            }
            catch (Exception e) {
                throw new MaachangDaoException(e);
            }
        }
        finally {
            if (session != null) {
                session.clear();
            }
        }
    }

    public void remove(Record record, ImageOp im, ArrayList<String> delJoins, Map<String, List<String>> srcJoin, String where, ArrayList<Object> params) throws MaachangDaoException {
        DaoSession session = null;
        try {
            try {
                session = this.getSession(record);
                ArrayList<String> sql = this.parseSql(where);
                Object[] pms = this.convertInputList(sql, params);
                where = this.srcSql(sql);
                MaachangDao.getInstance().delete(session, (DeleteJoinPlugin)im, delJoins, srcJoin, this.model, where, pms);
                session.clear();
                session = null;
            }
            catch (MaachangDaoException md) {
                throw md;
            }
            catch (Exception e) {
                throw new MaachangDaoException(e);
            }
        }
        finally {
            if (session != null) {
                session.clear();
            }
        }
    }

    public void remove(Record record, ImageOp im, ArrayList<String> delJoins, Map<String, List<String>> srcJoin, Map<String, Object> data) throws MaachangDaoException {
        DaoSession session = null;
        try {
            try {
                session = this.getSession(record);
                Map<String, Object> map = this.convertBeanByJoin(data);
                map = this.convertInputMap(map);
                MaachangDao.getInstance().delete(session, (DeleteJoinPlugin)im, delJoins, srcJoin, this.model, map);
                session.clear();
                session = null;
            }
            catch (MaachangDaoException md) {
                throw md;
            }
            catch (Exception e) {
                throw new MaachangDaoException(e);
            }
        }
        finally {
            if (session != null) {
                session.clear();
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Map<String, Object>> find(Record record, Map<String, String> join, Map<String, List<String>> srcJoin, String where, List<Object> params) throws MaachangDaoException {
        DaoSession session = null;
        try {
            session = this.getSession(record);
            ArrayList<String> sql = this.parseSql(where);
            Object[] pms = this.convertInputList(sql, params);
            where = this.srcSql(sql);
            List res = MaachangDao.getInstance().find(session, join, srcJoin, this.model, where, pms);
            session.clear();
            session = null;
            List<Map<String, Object>> list = this.convertResult(res);
            return list;
        }
        catch (MaachangDaoException md) {
            throw md;
            catch (Exception e) {
                throw new MaachangDaoException(e);
            }
        }
        finally {
            if (session != null) {
                session.clear();
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Map<String, Object>> limit(Record record, Map<String, String> join, Map<String, List<String>> srcJoin, int offset, int limit, String where, List<Object> params) throws MaachangDaoException {
        DaoSession session = null;
        try {
            session = this.getSession(record);
            ArrayList<String> sql = this.parseSql(where);
            Object[] pms = this.convertInputList(sql, params);
            where = this.srcSql(sql);
            List res = MaachangDao.getInstance().find(session, join, srcJoin, this.model, where, offset, limit, pms);
            session.clear();
            session = null;
            List<Map<String, Object>> list = this.convertResult(res);
            return list;
        }
        catch (MaachangDaoException md) {
            throw md;
            catch (Exception e) {
                throw new MaachangDaoException(e);
            }
        }
        finally {
            if (session != null) {
                session.clear();
            }
        }
    }

    public List<Map<String, Object>> first(Record record, Map<String, String> join, Map<String, List<String>> srcJoin, String where, List<Object> params) throws MaachangDaoException {
        return this.limit(record, join, srcJoin, 0, 1, where, params);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResultLine readLine(Record record, String where, List<Object> params) throws MaachangDaoException {
        DaoSession session = null;
        try {
            session = this.getSession(record);
            ArrayList<String> sql = this.parseSql(where);
            Object[] pms = this.convertInputList(sql, params);
            where = this.srcSql(sql);
            JsResultLine ret = new JsResultLine();
            MaachangDao.getInstance().readLine((ResultLine)ret, session, this.model, where, pms);
            session.clear();
            session = null;
            JsResultLine jsResultLine = ret;
            return jsResultLine;
        }
        catch (MaachangDaoException md) {
            throw md;
            catch (Exception e) {
                throw new MaachangDaoException(e);
            }
        }
        finally {
            if (session != null) {
                session.clear();
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int count(Record record, String where, List<Object> params) throws MaachangDaoException {
        DaoSession session = null;
        try {
            session = this.getSession(record);
            ArrayList<String> sql = this.parseSql(where);
            Object[] pms = this.convertInputList(sql, params);
            where = this.srcSql(sql);
            int ret = MaachangDao.getInstance().count(session, this.model, where, pms);
            session.clear();
            session = null;
            int n = ret;
            return n;
        }
        catch (MaachangDaoException md) {
            throw md;
            catch (Exception e) {
                throw new MaachangDaoException(e);
            }
        }
        finally {
            if (session != null) {
                session.clear();
            }
        }
    }

    private DaoSession getSession(Record record) throws MaachangDaoException {
        return DaoSessionFactory.getInstance().getDaoSession(record);
    }

    private Map<String, Object> convertInputMap(Map<String, Object> map) throws Exception {
        if (map == null && map.size() <= 0) {
            return null;
        }
        MetaColumn meta = MetaFactory.getInstance().getMetaColumn(true, this.model);
        boolean[] result = new boolean[1];
        for (String name : map.keySet()) {
            Object value = DaoUtil.convertByDBObject(result, meta, this.model, name, map.get(name));
            if (!result[0]) continue;
            map.put(name, value);
        }
        return map;
    }

    private ArrayList<String> parseSql(String where) throws Exception {
        if (where == null || (where = where.trim()).length() <= 0) {
            return null;
        }
        return ParseSql.parseSQL(where);
    }

    private String srcSql(ArrayList<String> list) throws Exception {
        if (list == null || list.size() <= 0) {
            return null;
        }
        return ParseSql.srcSQL(list);
    }

    private Object[] convertInputList(ArrayList<String> sql, List<Object> params) throws Exception {
        if (sql == null || sql.size() <= 0 || params == null || params.size() <= 0) {
            return null;
        }
        ArrayList<String> paramNames = ParseSql.getValues(sql);
        int len = paramNames.size();
        if (len >= params.size()) {
            len = params.size();
        }
        if (len <= 0) {
            return null;
        }
        MetaColumn meta = MetaFactory.getInstance().getMetaColumn(true, this.model);
        Object[] ret = new Object[len];
        boolean[] result = new boolean[1];
        int cnt = 0;
        int i = 0;
        while (i < len) {
            String name = paramNames.get(i);
            Object o = DaoUtil.convertByDBObject(result, meta, this.model, name, params.get(i));
            if (result[0]) {
                ret[cnt] = o;
                ++cnt;
            }
            ++i;
        }
        return ret;
    }

    private List<Map<String, Object>> convertResult(List<Map<String, Object>> result) throws Exception {
        if (result == null || result.size() <= 0) {
            return null;
        }
        int len = result.size();
        int i = 0;
        while (i < len) {
            Map<String, Object> map = result.get(i);
            if (map.size() <= 0) {
                return null;
            }
            for (String name : map.keySet()) {
                List<Map<String, Object>> value = map.get(name);
                if (value != null) {
                    if (value instanceof List) {
                        if (((List)value).size() > 0) {
                            value = this.convertResult(value);
                        }
                    } else if (value instanceof Map) {
                        Map valueMap = (Map)((Object)value);
                        if (valueMap.size() > 0) {
                            for (String valueMapName : valueMap.keySet()) {
                                Object valueMapValue = valueMap.get(valueMapName);
                                valueMapValue = DaoUtil.convertResult(this.model, valueMapName, valueMapValue);
                                valueMap.put(valueMapName, valueMapValue);
                            }
                        }
                    } else {
                        value = DaoUtil.convertResult(this.model, name, value);
                    }
                }
                map.put(name, value);
            }
            ++i;
        }
        return result;
    }

    private Map<String, Object> convertBeanByJoin(Map<String, Object> map) throws Exception {
        if (map == null || map.size() <= 0) {
            return map;
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (String name : map.keySet()) {
            Object value = map.get(name);
            if (value != null) {
                if (value instanceof List) {
                    if (((List)value).size() > 0) {
                        value = ((Map)((List)value).get(0)).get("id");
                    }
                } else if (value instanceof Map) {
                    value = ((Map)value).get("id");
                }
            }
            ret.put(name, value);
        }
        return ret;
    }
}

