/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.dao;

import java.util.Iterator;
import java.util.Map;
import org.maachang.comet.httpd.engine.script.dao.MasterCacheChild;
import org.maachang.util.thread.LoopThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MasterCacheMonitor
extends LoopThread {
    private long time = -1L;
    private Map<String, Object> cache = null;

    protected MasterCacheMonitor(Map<String, Object> cache, long time) throws Exception {
        this.time = time;
        this.cache = cache;
        this.startThread();
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        super.stopThread();
    }

    protected void clear() {
        this.cache = null;
        this.time = -1L;
    }

    protected boolean execution() throws Exception {
        if (this.cache.size() <= 0) {
            return false;
        }
        Iterator<String> it = this.cache.keySet().iterator();
        while (it.hasNext()) {
            if (super.isStop()) break;
            String key = it.next();
            Object o = this.cache.get(key);
            if (o == null || !(o instanceof MasterCacheChild)) {
                Thread.sleep(30L);
                continue;
            }
            MasterCacheChild ch = (MasterCacheChild)o;
            if (ch.getLastAccessTime() != -1L && ch.getLastAccessTime() + this.time <= System.currentTimeMillis()) {
                ch.clearValue();
            }
            Thread.sleep(30L);
        }
        return true;
    }
}

