/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.js;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.maachang.comet.conf.PackagesConfig;
import org.maachang.comet.httpd.HttpdBinary;
import org.maachang.comet.httpd.HttpdResponse;
import org.maachang.comet.httpd.engine.HttpdUtil;
import org.maachang.comet.net.HttpdParamsImpl;
import org.maachang.manager.GlobalManager;
import org.maachang.util.StringUtil;

public class JsDef {
    public static final String[] JS_OPTION = new String[]{"$limit", "$offset", "$order"};
    public static final String JS_EXIT_BY_RESULT = "_$_$exit$of$result$_$_";

    private JsDef() {
    }

    public static final void putResponseByData(HttpdResponse response, InputStream data) throws Exception {
        if (response == null || data == null) {
            if (data != null) {
                try {
                    data.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return;
        }
        BufferedInputStream bi = null;
        bi = !(data instanceof BufferedInputStream) ? new BufferedInputStream(data) : (BufferedInputStream)data;
        OutputStream output = null;
        try {
            output = response.getOutput();
            byte[] bin = new byte[512];
            while (true) {
                int len;
                if ((len = bi.read(bin)) <= 0) {
                    if (len > -1) continue;
                    break;
                }
                output.write(bin, 0, len);
            }
            bi.close();
            bi = null;
        }
        finally {
            if (bi != null) {
                try {
                    bi.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static final int arrayLength(Object[] objs) {
        if (objs == null) {
            return 0;
        }
        return objs.length;
    }

    public static final Object getArray(Object[] objs, int no) {
        if (objs == null) {
            return null;
        }
        return objs[no];
    }

    public static final void setArray(Object[] objs, int no, Object value) {
        if (objs == null) {
            return;
        }
        objs[no] = value;
    }

    public static final boolean isBinary(Object value) {
        if (value == null) {
            return false;
        }
        return value instanceof byte[];
    }

    public static final int binaryLength(byte[] objs) {
        if (objs == null) {
            return 0;
        }
        return objs.length;
    }

    public static final Object getBinary(byte[] objs, int no) {
        if (objs == null) {
            return null;
        }
        return objs[no];
    }

    public static final void setBinaryByByte(byte[] objs, int no, byte value) {
        if (objs == null) {
            return;
        }
        objs[no] = value;
    }

    public static final void setBinary(byte[] objs, int no, Object value) {
        if (objs == null) {
            return;
        }
        if (value instanceof String) {
            try {
                long data = Long.parseLong((String)value);
                objs[no] = (byte)(data & 0xFFL);
            }
            catch (Exception exception) {}
        } else if (value instanceof Short) {
            objs[no] = (byte)((Short)value & 0xFF);
        } else if (value instanceof Integer) {
            objs[no] = (byte)((Integer)value & 0xFF);
        } else if (value instanceof Long) {
            objs[no] = (byte)((Long)value & 0xFFL);
        }
    }

    public static final byte[] createBinary(int size) {
        if (size <= 0) {
            return null;
        }
        return new byte[size];
    }

    public static final String convertBinaryByString(byte[] binary, String charset) throws Exception {
        if (binary == null || binary.length <= 0) {
            return "";
        }
        if (charset == null || (charset = charset.trim()).length() <= 0) {
            charset = "UTF8";
        }
        return new String(binary, charset);
    }

    public static final byte[] convertStringByBinary(String string, String charset) throws Exception {
        if (string == null || string.length() <= 0) {
            return new byte[0];
        }
        if (charset == null || (charset = charset.trim()).length() <= 0) {
            charset = "UTF8";
        }
        return string.getBytes(charset);
    }

    public static final String toBinaryString(byte[] binary) {
        if (binary == null || binary.length <= 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        int len = binary.length;
        buf.append("[");
        int i = 0;
        while (i < len) {
            String c;
            if (i != 0) {
                buf.append(",");
            }
            if ((c = Integer.toHexString(binary[i] & 0xFF)).length() == 1) {
                c = "0" + c;
            }
            buf.append("0x").append(c);
            ++i;
        }
        buf.append("]");
        return buf.toString();
    }

    public static final Object convertPrimitive(String type, Object value) {
        String s;
        if (type == null || (type = type.trim()).length() <= 0) {
            return value;
        }
        if ("bool".equals(type = type.toLowerCase()) || "boolean".equals(type)) {
            return new Boolean(String.valueOf(value));
        }
        if (("char".equals(type) || "character".equals(type)) && (s = String.valueOf(value)) != null && s.length() > 0) {
            return new Character(s.charAt(0));
        }
        if ("short".equals(type)) {
            return new Short(String.valueOf(value));
        }
        if ("int".equals(type) || "integer".equals(type)) {
            return new Integer(String.valueOf(value));
        }
        if ("long".equals(type)) {
            return new Long(String.valueOf(value));
        }
        if ("float".equals(type)) {
            return new Float(String.valueOf(value));
        }
        if ("double".equals(type)) {
            return new Double(String.valueOf(value));
        }
        return value;
    }

    public static final int getDefaultPackageId() {
        PackagesConfig pconf = (PackagesConfig)GlobalManager.getValue((String)"PACKAGES_MANAGER");
        if (pconf == null) {
            return -1;
        }
        return pconf.getUpdateId();
    }

    public static final int pushDefaultPackage(StringBuilder buf) throws Exception {
        PackagesConfig pconf = (PackagesConfig)GlobalManager.getValue((String)"PACKAGES_MANAGER");
        if (pconf == null) {
            return -1;
        }
        int updateId = pconf.getUpdateId();
        String[] pk = pconf.getPackages();
        if (pk != null && pk.length > 0) {
            int len = pk.length;
            int i = 0;
            while (i < len) {
                if (pk[i] != null) {
                    buf.append(pk[i]).append("\n");
                }
                ++i;
            }
        }
        return updateId;
    }

    public static final int pushDefaultPackage(int[] outLine, StringBuilder buf) throws Exception {
        if (outLine == null || outLine.length <= 0) {
            return JsDef.pushDefaultPackage(buf);
        }
        outLine[0] = 0;
        PackagesConfig pconf = (PackagesConfig)GlobalManager.getValue((String)"PACKAGES_MANAGER");
        if (pconf == null) {
            return -1;
        }
        int updateId = pconf.getUpdateId();
        String[] pk = pconf.getPackages();
        if (pk != null && pk.length > 0) {
            int len = pk.length;
            int i = 0;
            while (i < len) {
                if (pk[i] != null) {
                    buf.append(pk[i]).append("\n");
                    outLine[0] = outLine[0] + 1;
                }
                ++i;
            }
        }
        return updateId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final long convertDateFormatByString(String format, String value) throws Exception {
        SimpleDateFormat fmt;
        long ret = -1L;
        SimpleDateFormat simpleDateFormat = fmt = new SimpleDateFormat(format, Locale.US);
        synchronized (simpleDateFormat) {
            Date date = fmt.parse(value);
            ret = date.getTime();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String convertDateFormatByLong(String format, long value) throws Exception {
        SimpleDateFormat fmt;
        String ret = null;
        SimpleDateFormat simpleDateFormat = fmt = new SimpleDateFormat(format, Locale.US);
        synchronized (simpleDateFormat) {
            ret = fmt.format(new Date(value));
        }
        return ret;
    }

    public static final String objectClassName(Object obj) {
        if (obj == null) {
            return "null";
        }
        return obj.getClass().getName();
    }

    public static final String convertByViewHtml(boolean mode, String o) {
        if (o == null || (o = o.trim()).length() <= 0) {
            return "";
        }
        o = StringUtil.changeString((String)o, (String)"&", (String)"&amp;");
        o = StringUtil.changeString((String)o, (String)"<", (String)"&lt;");
        o = StringUtil.changeString((String)o, (String)">", (String)"&gt;");
        o = StringUtil.changeString((String)o, (String)"'", (String)"&#039;");
        o = StringUtil.changeString((String)o, (String)"\"", (String)"&#034;");
        if (mode) {
            o = StringUtil.changeString((String)o, (String)"\n", (String)"<br>");
        }
        return o;
    }

    public static final String convertByJson(String o) {
        if (o == null || o.length() <= 0) {
            return "";
        }
        o = StringUtil.upIndentCote((String)o);
        o = StringUtil.changeString((String)o, (String)"\r", (String)"\\r");
        return StringUtil.changeString((String)o, (String)"\n", (String)"\\n");
    }

    public static final String convetByCote(boolean mode, String o) {
        if (o == null || o.length() <= 0) {
            return "";
        }
        int bafCode = -1;
        char target = !mode ? (char)'\'' : '\"';
        int len = o.length();
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < len) {
            char c = o.charAt(i);
            if (target == c) {
                if (bafCode == 92) {
                    buf.append("\\\\");
                } else {
                    buf.append("\\");
                }
            }
            buf.append(c);
            bafCode = c;
            ++i;
        }
        return buf.toString();
    }

    public static final String convertByEnter(String o) {
        if (o == null || o.length() <= 0) {
            return "";
        }
        o = StringUtil.changeString((String)o, (String)"\r", (String)"\\r");
        return StringUtil.changeString((String)o, (String)"\n", (String)"\\n");
    }

    public static final byte[] getParamByBinary(Object o) {
        if (o == null || !(o instanceof HttpdBinary)) {
            return null;
        }
        return ((HttpdBinary)o).getBinary();
    }

    public static final int getParamByBinaryLength(Object o) {
        if (o == null || !(o instanceof HttpdBinary)) {
            return -1;
        }
        return ((HttpdBinary)o).getLength();
    }

    public static final String getParamByOriginalName(Object o) {
        if (o == null || !(o instanceof HttpdBinary)) {
            return null;
        }
        return ((HttpdBinary)o).getOriginalName();
    }

    public static final String convertURL(boolean mode, String body, String charset) {
        if (body == null || (body = body.trim()).length() <= 0) {
            return null;
        }
        if (charset == null || (charset = charset.trim()).length() <= 0) {
            charset = "UTF8";
        }
        try {
            HttpdParamsImpl params = new HttpdParamsImpl();
            HttpdUtil.convertQueryByParams(params, body, charset);
            StringBuilder buf = new StringBuilder();
            String[] keys = params.getKeys();
            if (keys != null) {
                int len = keys.length;
                int cnt = 0;
                int i = 0;
                while (i < len) {
                    int lenJ = params.size(keys[i]);
                    int j = 0;
                    while (j < lenJ) {
                        String v;
                        if (cnt != 0) {
                            buf.append("&");
                        }
                        if ((v = params.getParam(keys[i], j)) == null || (v = v.trim()).length() <= 0) {
                            buf.append(keys[i]).append("=");
                        } else if (mode) {
                            buf.append(keys[i]).append("=").append(URLEncoder.encode(v, charset));
                        } else if (mode) {
                            buf.append(keys[i]).append("=").append(v);
                        }
                        ++cnt;
                        ++j;
                    }
                    ++i;
                }
                return buf.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static final boolean isUseString(String str) {
        if (str == null || str.length() <= 0) {
            return false;
        }
        int len = str.length();
        int i = 0;
        while (i < len) {
            char c = str.charAt(i);
            if (c != ' ' && c != '\t' && c != '\u3000') {
                return true;
            }
            ++i;
        }
        return false;
    }
}

