/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.scripts;

import org.maachang.comet.httpd.HttpdStateException;
import org.maachang.comet.httpd.engine.script.ExecutionScript;
import org.maachang.comet.httpd.engine.script.Script;
import org.maachang.comet.httpd.engine.script.ScriptDef;
import org.maachang.comet.httpd.engine.script.SrcScript;
import org.maachang.comet.httpd.engine.script.js.JsDef;
import org.maachang.comet.httpd.engine.script.scripts.ExecutionScriptImpl;
import org.maachang.comet.httpd.engine.script.scripts.ReadScriptPlus;
import org.maachang.util.FileUtil;

public abstract class AbstractScript
implements Script {
    protected String path = null;
    protected String fileName = null;
    protected long updateTime = -1L;
    protected String type = null;
    protected SrcScript srcScript = null;
    protected int packageId = -1;
    protected ExecutionScript executionScript = null;

    public synchronized ExecutionScript getScript() throws Exception {
        if (!FileUtil.isFileExists((String)this.fileName)) {
            throw new HttpdStateException(500, "\u5bfe\u8c61" + this.type + "\u30d5\u30a1\u30a4\u30eb[" + this.path + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (this.executionScript == null || this.updateTime != FileUtil.getLastTime((String)this.fileName) || this.packageId != JsDef.getDefaultPackageId()) {
            this.readScript();
        }
        return this.executionScript;
    }

    protected void clear() {
        this.updateTime = -1L;
        this.srcScript = null;
        this.executionScript = null;
    }

    public synchronized String getPath() {
        return this.path;
    }

    public synchronized String getScriptName() {
        return this.fileName;
    }

    public abstract int getScriptType();

    public synchronized SrcScript getSrcScript() {
        return this.srcScript;
    }

    public synchronized boolean isScript() {
        return this.executionScript != null;
    }

    protected abstract String addHeaderScript() throws Exception;

    protected abstract String addFooterScript() throws Exception;

    protected void create(String type, String baseDirectory, String path, String currentDirectory) throws Exception {
        String fileName;
        if (path == null || (path = path.trim()).length() <= 0) {
            this.clear();
            throw new HttpdStateException(404, String.valueOf(type) + "\u306e\u6307\u5b9a\u30d1\u30b9\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (!path.endsWith(".ms")) {
            path = String.valueOf(path) + ".ms";
        }
        if (!FileUtil.isFileExists((String)(fileName = (currentDirectory = ScriptDef.trimCurrentDirectory(currentDirectory)) + baseDirectory + path))) {
            this.clear();
            throw new HttpdStateException(404, "\u5bfe\u8c61" + type + "\u30d5\u30a1\u30a4\u30eb[" + path + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (path.endsWith(".ms")) {
            path = path.substring(0, path.length() - ".ms".length());
        }
        this.path = path;
        this.type = type;
        this.fileName = fileName;
    }

    protected void readScript() throws Exception {
        String script = null;
        String header = this.addHeaderScript();
        String footer = this.addFooterScript();
        if (header == null && footer == null) {
            StringBuilder buf = new StringBuilder();
            this.packageId = JsDef.pushDefaultPackage(buf);
            String s = FileUtil.getFileByString((String)this.fileName, (String)"UTF8");
            buf.append(s);
            s = null;
            script = buf.toString();
        } else {
            StringBuilder buf = new StringBuilder();
            this.packageId = JsDef.pushDefaultPackage(buf);
            if (header != null) {
                buf.append(header).append("\n");
            }
            String s = FileUtil.getFileByString((String)this.fileName, (String)"UTF8");
            buf.append(s);
            s = null;
            if (footer != null) {
                buf.append("\n").append(footer);
            }
            script = buf.toString();
            buf = null;
        }
        this.srcScript = new SrcScript(script);
        script = ReadScriptPlus.convert(true, script);
        this.executionScript = new ExecutionScriptImpl("jss", this.getScriptType(), this.getPath(), script);
        script = null;
        this.updateTime = FileUtil.getLastTime((String)this.fileName);
    }
}

