/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.scripts;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.httpd.HttpdRequest;
import org.maachang.comet.httpd.HttpdResponse;
import org.maachang.comet.httpd.HttpdStateException;
import org.maachang.comet.httpd.engine.HttpdResponseInstance;
import org.maachang.comet.httpd.engine.HttpdTimestamp;
import org.maachang.comet.httpd.engine.comet.CometManager;
import org.maachang.comet.httpd.engine.script.Script;
import org.maachang.comet.httpd.engine.script.scripts.AjaxScript;
import org.maachang.comet.httpd.engine.script.scripts.CometScript;
import org.maachang.comet.httpd.engine.script.scripts.ControllerScript;
import org.maachang.comet.httpd.engine.script.scripts.EtcScript;
import org.maachang.comet.httpd.engine.script.scripts.FilterScript;
import org.maachang.comet.httpd.engine.script.scripts.InnerScript;
import org.maachang.comet.httpd.engine.script.scripts.MhtmlScript;
import org.maachang.comet.httpd.engine.script.scripts.ReportScript;
import org.maachang.comet.httpd.engine.script.scripts.RpcScript;
import org.maachang.comet.httpd.engine.script.scripts.TargetScript;
import org.maachang.comet.httpd.engine.script.scripts.TemplateScript;
import org.maachang.comet.httpd.engine.script.scripts.TriggerScript;
import org.maachang.manager.GlobalManager;
import org.maachang.util.FileUtil;

public abstract class ScriptManager {
    private static final Log LOG = LogFactory.getLog(ScriptManager.class);
    public static final String SCRIPT_PLUS = ".ms";
    public static final String SCRIPT_HTML_PLUS = ".mhtml";
    public static final String TEMPLATE_PLUS = ".mttml";
    public static final String FILTER_NAME = "filter";
    public static final String SCRIPT_BY_COMET = "Comet";
    public static final String SCRIPT_BY_TRIGGER = "Trigger";
    public static final String SCRIPT_BY_AJAX = "Ajax";
    public static final String SCRIPT_BY_REPORT = "Report";
    public static final String SCRIPT_BY_CONTROLLER = "Controller";
    public static final String SCRIPT_BY_RPC = "Rpc";
    public static final String SCRIPT_BY_INNER = "Inner";
    public static final String SCRIPT_BY_FILTER = "Filter";
    public static final int SCRIPT_TYPE_BY_NOT = -1;
    public static final int SCRIPT_TYPE_BY_COMET = 0;
    public static final int SCRIPT_TYPE_BY_TRIGGER = 1;
    public static final int SCRIPT_TYPE_BY_AJAX = 2;
    public static final int SCRIPT_TYPE_BY_CONTROLLER = 3;
    public static final int SCRIPT_TYPE_BY_RPC = 4;
    public static final int SCRIPT_TYPE_BY_REPORT = 6;
    public static final int SCRIPT_TYPE_BY_HTML = 10;
    public static final int SCRIPT_TYPE_BY_MODEL = 20;
    public static final int SCRIPT_TYPE_BY_LIB = 30;
    public static final int SCRIPT_TYPE_BY_INNER = 31;
    public static final int SCRIPT_TYPE_BY_FILTER = 98;
    public static final int SCRIPT_TYPE_BY_ETC = 99;

    private ScriptManager() {
    }

    public static final Script getScript(String name, String dir) throws Exception {
        Script ret;
        if (name == null || (name = name.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u6307\u5b9a\u3055\u308c\u305f\u30b9\u30af\u30ea\u30d7\u30c8\u30d1\u30b9\u306f\u4e0d\u6b63\u3067\u3059");
        }
        String key = ScriptManager.cutScriptPlus(name);
        if (name.endsWith("/filter")) {
            ret = new FilterScript(key, dir);
        } else if (name.endsWith(SCRIPT_HTML_PLUS)) {
            ret = new MhtmlScript(name, dir);
        } else if (name.endsWith(TEMPLATE_PLUS)) {
            ret = new TemplateScript(name);
        } else {
            int type = ScriptManager.getScriptFileType(String.valueOf(key) + SCRIPT_PLUS);
            switch (type) {
                case 0: {
                    ret = new CometScript(key, dir);
                    break;
                }
                case 1: {
                    ret = new TriggerScript(key, dir);
                    break;
                }
                case 2: {
                    ret = new AjaxScript(key, dir);
                    break;
                }
                case 6: {
                    ret = new ReportScript(key, dir);
                    break;
                }
                case 3: {
                    ret = new ControllerScript(key, dir);
                    break;
                }
                case 4: {
                    ret = new RpcScript(key, dir);
                    break;
                }
                case 31: {
                    ret = new InnerScript(key, dir);
                    break;
                }
                case 98: {
                    ret = new FilterScript(key, dir);
                    break;
                }
                default: {
                    ret = new EtcScript(key, dir);
                }
            }
        }
        return ret;
    }

    public static final HttpdResponse execution(HttpdRequest request, String appDirectory) throws Exception {
        if (request == null) {
            throw new HttpdStateException(400, "\u30ea\u30af\u30a8\u30b9\u30c8\u304c\u4e0d\u6b63\u3067\u3059");
        }
        String path = ScriptManager.trimScriptPath(request.getUrlPath());
        if (path == null) {
            throw new HttpdStateException(404, "\u6307\u5b9a\u30d1\u30b9[" + request.getUrlPath() + "]\u306e\u5185\u5bb9\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        HttpdResponse ret = null;
        try {
            if (path.endsWith(TEMPLATE_PLUS)) {
                ret = HttpdResponseInstance.createResponse(request, request.getUrlPath(), request.getKeepAliveTimeout(), request.getKeepAliveCount());
                ret.setHttpCache(true);
                ret.setHttpClose(false);
                if (!ScriptManager.executionFilter(ret, path, request, appDirectory)) {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    ret.setCookieSession(request);
                    ret.getHeader().addHeader("Last-Modified", HttpdTimestamp.getTimestamp(TemplateScript.getTime(path)));
                    params.put("_$script$request", request);
                    params.put("_$script$response", ret);
                    Object res = TargetScript.executionScript(path, request, params);
                    ScriptManager.resultError(path, res);
                }
            } else {
                String fullPath = String.valueOf(appDirectory) + path.substring(1, path.length());
                if (!FileUtil.isFileExists((String)(String.valueOf(fullPath) + SCRIPT_PLUS))) {
                    String controllerPath = String.valueOf(path) + SCRIPT_BY_CONTROLLER;
                    fullPath = String.valueOf(appDirectory) + controllerPath.substring(1, controllerPath.length());
                    if (!FileUtil.isFileExists((String)(String.valueOf(fullPath) + SCRIPT_PLUS))) {
                        path = String.valueOf(path) + SCRIPT_HTML_PLUS;
                        fullPath = String.valueOf(appDirectory) + path.substring(1, path.length());
                        if (!FileUtil.isFileExists((String)fullPath)) {
                            throw new HttpdStateException(404, "\u6307\u5b9a\u30d1\u30b9[" + request.getUrlPath() + "]\u306e\u5185\u5bb9\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
                        }
                    } else {
                        path = String.valueOf(controllerPath) + SCRIPT_PLUS;
                        fullPath = String.valueOf(fullPath) + SCRIPT_PLUS;
                    }
                } else {
                    path = String.valueOf(path) + SCRIPT_PLUS;
                    fullPath = String.valueOf(fullPath) + SCRIPT_PLUS;
                }
                if (!FileUtil.isRead((String)fullPath)) {
                    throw new HttpdStateException(403, "\u6307\u5b9a\u30d1\u30b9[" + request.getUrlPath() + "]\u306f\u8aad\u307f\u8fbc\u307f\u6a29\u9650\u304c\u3042\u308a\u307e\u305b\u3093");
                }
                long time = FileUtil.getLastTime((String)fullPath);
                fullPath = null;
                int type = ScriptManager.getScriptFileType(path);
                switch (type) {
                    case 0: {
                        request.setBody(null);
                        CometManager man = (CometManager)GlobalManager.getValue((String)"COMET_MANAGER");
                        man.cometRequest(request.copy());
                        request.getConnectionInfo().cometOn();
                        if (!LOG.isDebugEnabled()) break;
                        LOG.debug((Object)("set Comet...groupId:" + request.getQuery().getParam("groupId")));
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: {
                        ret = HttpdResponseInstance.createResponse(request, request.getUrlPath(), request.getKeepAliveTimeout(), request.getKeepAliveCount());
                        ret.setHttpCache(true);
                        ret.setHttpClose(false);
                        if (ScriptManager.executionFilter(ret, path, request, appDirectory)) break;
                        if (type == 2 || type == 6 || type == 4) {
                            ret.setHttpCache(true);
                        }
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        ret.setCookieSession(request);
                        ret.getHeader().addHeader("Last-Modified", HttpdTimestamp.getTimestamp(time));
                        params.put("_$script$request", request);
                        params.put("_$script$response", ret);
                        Object res = TargetScript.executionScript(path, request, params);
                        ScriptManager.resultError(path, res);
                        break;
                    }
                    case 31: 
                    case 98: {
                        throw new HttpdStateException(403, "\u6307\u5b9a\u30d1\u30b9[" + path + "]\u306e\u5185\u5bb9\u306f\u30a2\u30af\u30bb\u30b9\u3067\u304d\u307e\u305b\u3093");
                    }
                    default: {
                        if (path.endsWith(SCRIPT_HTML_PLUS)) {
                            ret = HttpdResponseInstance.createResponse(request, path, request.getKeepAliveTimeout(), request.getKeepAliveCount());
                            ret.setHttpCache(true);
                            ret.setHttpClose(false);
                            if (ScriptManager.executionFilter(ret, path, request, appDirectory)) break;
                            HashMap<String, Object> params = new HashMap<String, Object>();
                            ret.setCookieSession(request);
                            ret.getHeader().addHeader("Last-Modified", HttpdTimestamp.getTimestamp(time));
                            params.put("_$script$request", request);
                            params.put("_$script$response", ret);
                            Object res = TargetScript.executionScript(path, request, params);
                            ScriptManager.resultError(path, res);
                            break;
                        }
                        throw new HttpdStateException(404, "\u6307\u5b9a\u30d1\u30b9[" + path + "]\u306e\u5185\u5bb9\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
                    }
                }
            }
            return ret;
        }
        catch (Exception e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
    }

    public static final String cutScriptPlus(String name) {
        if (name.endsWith(SCRIPT_PLUS)) {
            return name.substring(0, name.length() - SCRIPT_PLUS.length());
        }
        return name;
    }

    public static final String trimScriptPath(String path) {
        String lower = path.toLowerCase();
        if (path.endsWith("/")) {
            return String.valueOf(path) + "index";
        }
        if (lower.endsWith(SCRIPT_PLUS)) {
            path = path.substring(0, path.length() - SCRIPT_PLUS.length());
        } else if (lower.endsWith(SCRIPT_HTML_PLUS)) {
            path = path.substring(0, path.length() - SCRIPT_HTML_PLUS.length());
        }
        return path;
    }

    public static final String searchFilterPath(String path, String dir) throws Exception {
        while (true) {
            path = path.substring(0, path.length() - FileUtil.getFileName((String)path).length());
            String filterPath = path + FILTER_NAME + SCRIPT_PLUS;
            String fullPath = FileUtil.getFullPath((String)(dir + filterPath));
            if (FileUtil.isFileExists((String)fullPath) && FileUtil.isRead((String)fullPath)) {
                return filterPath;
            }
            if (path.length() <= 1) {
                return null;
            }
            path = path.substring(0, path.length() - 1);
        }
    }

    public static final int getScriptByAllTyep(String name) {
        if (name.endsWith(SCRIPT_HTML_PLUS)) {
            return 10;
        }
        if (!name.endsWith(SCRIPT_PLUS)) {
            name = String.valueOf(name) + SCRIPT_PLUS;
        }
        return ScriptManager.getScriptFileType(name);
    }

    public static final int getScriptFileType(String name) {
        if (name == null || (name = name.trim()).length() <= 0) {
            return -1;
        }
        String check = null;
        if (!name.endsWith(SCRIPT_PLUS)) {
            return -1;
        }
        check = name.substring(0, name.length() - SCRIPT_PLUS.length());
        if (check.endsWith(SCRIPT_BY_COMET)) {
            return 0;
        }
        if (check.endsWith(SCRIPT_BY_TRIGGER)) {
            return 1;
        }
        if (check.endsWith(SCRIPT_BY_AJAX)) {
            return 2;
        }
        if (check.endsWith(SCRIPT_BY_REPORT)) {
            return 6;
        }
        if (check.endsWith(SCRIPT_BY_CONTROLLER)) {
            return 3;
        }
        if (check.endsWith(SCRIPT_BY_RPC)) {
            return 4;
        }
        if (check.endsWith(SCRIPT_BY_INNER)) {
            return 31;
        }
        if (check.endsWith(SCRIPT_BY_FILTER)) {
            return 98;
        }
        return -1;
    }

    public static final String getTypeByString(int type) {
        switch (type) {
            case -1: {
                return "etc";
            }
            case 0: {
                return "comet";
            }
            case 1: {
                return "trigger";
            }
            case 2: {
                return "ajax";
            }
            case 6: {
                return "report";
            }
            case 3: {
                return "controller";
            }
            case 4: {
                return "rpc";
            }
            case 10: {
                return "html";
            }
            case 20: {
                return "model";
            }
            case 30: {
                return "lib";
            }
            case 31: {
                return "inner";
            }
            case 99: {
                return "etc";
            }
        }
        return "etc";
    }

    public static final boolean isScript(String name) {
        if (name == null || (name = name.trim()).length() <= 0) {
            return false;
        }
        return (name = name.toLowerCase()).endsWith(SCRIPT_PLUS) || name.endsWith(SCRIPT_HTML_PLUS);
    }

    private static final boolean executionFilter(HttpdResponse response, String path, HttpdRequest request, String appDirectory) throws Exception {
        String filterPath = ScriptManager.searchFilterPath(path, appDirectory);
        if (filterPath == null) {
            return false;
        }
        String fullPath = FileUtil.getFullPath((String)(appDirectory + filterPath));
        if (FileUtil.isFileExists((String)fullPath) && FileUtil.isRead((String)fullPath)) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            response.setCookieSession(request);
            response.getHeader().addHeader("Last-Modified", HttpdTimestamp.getTimestamp(FileUtil.getLastTime((String)fullPath)));
            params.put("_$script$request", request);
            params.put("_$script$response", response);
            Object res = TargetScript.executionScript(filterPath, request, params);
            if (response.isOutputStream() || "redirect".equals(res) || "forward".equals(res)) {
                return true;
            }
        }
        return false;
    }

    private static final void resultError(String path, Object res) throws Exception {
        if (res != null && res instanceof String && ((String)res).startsWith("error")) {
            String s = (String)res;
            s = s.substring("error".length());
            int state = -1;
            try {
                state = Integer.parseInt(s);
            }
            catch (Exception e) {
                state = 500;
            }
            throw new HttpdStateException(state, "\u6307\u5b9a\u30d1\u30b9[" + path + "]\u306e\u51e6\u7406\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
        }
    }
}

