/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequestBuffer {
    private static final Log LOG = LogFactory.getLog(RequestBuffer.class);
    protected static final int MAX_LENGTH = 0x2000000;
    private static final int BUFFER = 8192;
    private byte[] binary = new byte[8192];
    private int length = 0;

    protected void finalize() throws Exception {
        this.destroy();
    }

    protected void destroy() {
        this.binary = null;
        this.length = 0;
    }

    public void reset() {
        if (this.binary.length == 8192) {
            this.length = 0;
        } else {
            this.binary = new byte[8192];
            this.length = 0;
        }
    }

    public void write(int b) throws Exception {
        if (this.length >= 0x2000000) {
            this.reset();
            LOG.warn((Object)"## \u53d7\u4fe1\u30c7\u30fc\u30bf\u9577\u304c\u6700\u5927\u5024[33554432]\u3092\u8d8a\u3057\u305f\u5185\u5bb9\u3092\u78ba\u8a8d\u3057\u307e\u3057\u305f");
            throw new IOException("\u53d7\u4fe1\u30c7\u30fc\u30bf\u9577\u304c\u6700\u5927\u5024[33554432]\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
        }
        if (this.binary.length <= this.length) {
            byte[] t = this.binary;
            int iLen = t.length * 2;
            if (iLen >= 0x2000000) {
                iLen = 0x2000000;
            }
            this.binary = new byte[iLen];
            System.arraycopy(t, 0, this.binary, 0, t.length);
            byte[] byArray = null;
        }
        this.binary[this.length] = (byte)(b & 0xFF);
        ++this.length;
    }

    public byte getByte(int no) {
        return this.binary[no];
    }

    public byte[] getBinary() {
        return this.binary;
    }

    public byte[] getBinary(int length) {
        if (length <= 0) {
            length = this.length;
        }
        if (this.length < length) {
            length = this.length;
        }
        byte[] ret = new byte[length];
        System.arraycopy(this.binary, 0, ret, 0, length);
        return ret;
    }

    public void compact(int pos) throws Exception {
        if (pos <= -1) {
            throw new IllegalArgumentException("\u30dd\u30b8\u30b7\u30e7\u30f3\u5024\u306f\u8ca0\u306e\u5024\u3092\u8a2d\u5b9a\u3067\u304d\u307e\u305b\u3093");
        }
        if (pos <= 0) {
            return;
        }
        int len = this.length - pos;
        if (len <= -1) {
            throw new IllegalArgumentException("\u6307\u5b9a\u30dd\u30b8\u30b7\u30e7\u30f3\u5024(" + pos + ")\u306f\u7bc4\u56f2\u3092\u8d85\u3057\u3066\u3044\u307e\u3059");
        }
        byte[] b = new byte[len];
        System.arraycopy(this.binary, pos, b, 0, len);
        System.arraycopy(b, 0, this.binary, 0, len);
        this.length = len;
        b = null;
    }

    public int getLength() {
        return this.length;
    }
}

