/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import org.maachang.comet.net.nio.IsWriteQueue;
import org.maachang.comet.net.nio.ReceiveBuffer;
import org.maachang.comet.net.nio.WriteDataQueue;
import org.maachang.comet.net.ssl.SslElement;
import org.maachang.comet.net.ssl.SslOption;

public class NioElement {
    private SelectionKey key = null;
    private SocketChannel channel = null;
    private ReceiveBuffer buffer = null;
    private WriteDataQueue writeBuffer = null;
    private IsWriteQueue isWriteQueue = null;
    private long time = -1L;
    private boolean executionFlag = false;
    private boolean closeFlag = false;
    private Object object = null;
    private SslElement sslElement = null;
    private SslOption sslOption = null;
    private final Object sync = new Object();

    private NioElement() {
    }

    public NioElement(SocketChannel channel) throws Exception {
        this(channel, null);
    }

    public NioElement(SocketChannel channel, IsWriteQueue queue) throws Exception {
        if (channel == null || !channel.isConnected()) {
            throw new IOException("\u30bd\u30b1\u30c3\u30c8\u30c1\u30e3\u30cd\u30eb\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.channel = channel;
        this.isWriteQueue = queue;
        this.writeBuffer = new WriteDataQueue();
        this.buffer = new ReceiveBuffer();
        this.time = System.currentTimeMillis();
        this.executionFlag = false;
        this.closeFlag = false;
        this.object = null;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        Object object = this.sync;
        synchronized (object) {
            if (this.sslElement != null) {
                this.sslElement.destroy();
            }
            this.sslElement = null;
            if (this.key != null) {
                this.key.attach(null);
                try {
                    this.key.cancel();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.key = null;
            if (this.channel != null) {
                try {
                    this.channel.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.channel = null;
            if (this.buffer != null) {
                this.buffer.destroy();
            }
            this.buffer = null;
            if (this.writeBuffer != null) {
                this.writeBuffer.destroy();
            }
            this.writeBuffer = null;
            this.isWriteQueue = null;
            this.object = null;
            this.executionFlag = false;
            this.closeFlag = false;
            this.sslOption = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setIsWriteQueue(IsWriteQueue isWriteQueue) {
        Object object = this.sync;
        synchronized (object) {
            this.isWriteQueue = isWriteQueue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSsl(SslOption sslOption) {
        Object object = this.sync;
        synchronized (object) {
            this.sslOption = sslOption;
            this.sslElement = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SslElement getSslElement() {
        SslElement ret;
        Object object = this.sync;
        synchronized (object) {
            ret = this.sslElement;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SslOption getSslOption() {
        SslOption ret;
        Object object = this.sync;
        synchronized (object) {
            ret = this.sslOption;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSsl() throws Exception {
        Object object = this.sync;
        synchronized (object) {
            if (this.sslOption != null && this.sslElement == null) {
                try {
                    this.sslElement = new SslElement(this, this.sslOption.getSSLEngine());
                }
                catch (Exception e) {
                    this.sslElement = null;
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSsl() {
        Object object = this.sync;
        synchronized (object) {
            this.sslElement = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKey(SelectionKey key) {
        Object object = this.sync;
        synchronized (object) {
            this.key = key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SelectionKey getKey() {
        SelectionKey ret;
        Object object = this.sync;
        synchronized (object) {
            ret = this.key;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketChannel getChannel() {
        SocketChannel ret;
        Object object = this.sync;
        synchronized (object) {
            ret = this.channel;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReceiveBuffer getBuffer() {
        ReceiveBuffer ret;
        Object object = this.sync;
        synchronized (object) {
            ret = this.buffer;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBuffer() {
        boolean ret;
        Object object = this.sync;
        synchronized (object) {
            ret = this.buffer.length() > 0;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartWrite() {
        IsWriteQueue queue = null;
        boolean flg = false;
        Object object = this.sync;
        synchronized (object) {
            if (this.isWriteQueue != null && this.key != null && (this.key.interestOps() & 4) == 0) {
                queue = this.isWriteQueue;
                flg = true;
            }
        }
        if (flg) {
            queue.append(this);
            object = this.sync;
            synchronized (object) {
                this.key.selector().wakeup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteDataQueue getWriteDataQueue() {
        WriteDataQueue ret;
        Object object = this.sync;
        synchronized (object) {
            ret = this.writeBuffer;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWriteBuffer(ByteBuffer buffer) {
        WriteDataQueue buf;
        Object object = this.sync;
        synchronized (object) {
            buf = this.writeBuffer;
        }
        buf.append(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWriteBufferHead(ByteBuffer buffer) {
        WriteDataQueue buf;
        Object object = this.sync;
        synchronized (object) {
            buf = this.writeBuffer;
        }
        buf.appendHead(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getWriteBuffer() {
        WriteDataQueue buf;
        Object object = this.sync;
        synchronized (object) {
            buf = this.writeBuffer;
        }
        return buf.getQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWriteSize() {
        WriteDataQueue buf;
        Object object = this.sync;
        synchronized (object) {
            buf = this.writeBuffer;
        }
        return buf.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCloseFlag(boolean mode) {
        Object object = this.sync;
        synchronized (object) {
            this.closeFlag = mode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCloseFlag() {
        boolean ret;
        Object object = this.sync;
        synchronized (object) {
            ret = this.closeFlag;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        Object object = this.sync;
        synchronized (object) {
            this.time = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTime() {
        long ret;
        Object object = this.sync;
        synchronized (object) {
            ret = this.time;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setExecutionFlag(boolean flg) {
        Object object = this.sync;
        synchronized (object) {
            this.executionFlag = flg;
        }
        if (!flg) {
            this.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isExecutionFlag() {
        boolean ret;
        Object object = this.sync;
        synchronized (object) {
            ret = this.executionFlag;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(Object object) {
        Object object2 = this.sync;
        synchronized (object2) {
            this.object = object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject() {
        Object ret;
        Object object = this.sync;
        synchronized (object) {
            ret = this.object;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUse() {
        boolean ret;
        Object object = this.sync;
        synchronized (object) {
            ret = this.channel != null && this.channel.socket() != null;
        }
        if (!ret) {
            object = this.sync;
            synchronized (object) {
                if (this.sslElement != null) {
                    this.sslElement.destroy();
                }
                this.sslElement = null;
                if (this.buffer != null) {
                    this.buffer.destroy();
                }
                this.buffer = null;
                if (this.writeBuffer != null) {
                    this.writeBuffer.destroy();
                }
                this.writeBuffer = null;
            }
        }
        return ret;
    }

    public Object getSync() {
        return this.sync;
    }
}

