/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net.nio;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import org.maachang.comet.net.nio.NioElement;
import org.maachang.comet.net.nio.ReceiveBuffer;

class NioInputStream
extends InputStream {
    private static final long TIMEOUT = 5000L;
    private static final long MIN_TIMEOUT = 500L;
    private ReceiveBuffer recvBuffer = null;
    private byte[] buffer = null;
    private int bufferToPos = 0;
    private long timeout = -1L;
    private final Object sync = new Object();

    public InputStream create(NioElement element) throws Exception {
        return this.create(element, 5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream create(NioElement element, long timeout) throws Exception {
        if (element == null || !element.isUse()) {
            throw new IOException("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        Object object = this.sync;
        synchronized (object) {
            this.resetObject();
            this.recvBuffer = element.getBuffer();
            this.timeout = timeout <= 500L ? 500L : timeout;
            this.buffer = null;
            this.bufferToPos = 0;
        }
        return this;
    }

    protected void finalize() throws Exception {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetObject() {
        Object object = this.sync;
        synchronized (object) {
            if (this.recvBuffer != null && this.recvBuffer.length() <= 0) {
                this.recvBuffer.reset();
            }
            this.recvBuffer = null;
            this.buffer = null;
            this.bufferToPos = 0;
        }
    }

    public void close() {
        this.resetObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() throws IOException {
        int ret;
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        Object object = this.sync;
        synchronized (object) {
            ret = this.recvBuffer.length();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        ReceiveBuffer bm;
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        byte[] b = null;
        int bPos = 0;
        Object object = this.sync;
        synchronized (object) {
            bm = this.recvBuffer;
            b = this.buffer;
            bPos = this.bufferToPos;
        }
        if (b == null) {
            long time = System.currentTimeMillis();
            while (true) {
                if (!this.isUse()) {
                    throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
                }
                b = bm.get();
                if (b != null) {
                    Object object2 = this.sync;
                    synchronized (object2) {
                        this.buffer = b;
                        this.bufferToPos = 0;
                        bPos = 0;
                        break;
                    }
                }
                if (time + this.timeout <= System.currentTimeMillis()) {
                    throw new SocketTimeoutException("SocketTimeout");
                }
                try {
                    Thread.sleep(1L);
                }
                catch (Exception exception) {}
            }
        }
        int ret = b[bPos] & 0xFF;
        if (bPos + 1 >= b.length) {
            Object object3 = this.sync;
            synchronized (object3) {
                this.buffer = null;
                this.bufferToPos = 0;
            }
        }
        Object object4 = this.sync;
        synchronized (object4) {
            ++this.bufferToPos;
        }
        return ret;
    }

    public synchronized boolean markSupported() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean isUse() {
        boolean ret;
        Object object = this.sync;
        synchronized (object) {
            ret = this.recvBuffer != null && this.recvBuffer.isUse();
        }
        return ret;
    }
}

