/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net.nio;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.net.HttpdRequestImpl;
import org.maachang.comet.net.ReadHttpdRequest;
import org.maachang.comet.net.RequestBuffer;
import org.maachang.comet.net.nio.ConnectionInfo;
import org.maachang.comet.net.nio.ConnectionInfoImpl;
import org.maachang.comet.net.nio.HttpReceiveCallback;
import org.maachang.comet.net.nio.NioElement;
import org.maachang.comet.net.nio.ReceiveLinkQueue;
import org.maachang.util.SequenceSync;
import org.maachang.util.thread.LoopThread;

class NioPoolThread
extends LoopThread {
    private static final Log LOG = LogFactory.getLog(NioPoolThread.class);
    private static final long TIMEOUT = 15000L;
    private HttpReceiveCallback call = null;
    private ReceiveLinkQueue queue = null;
    private SequenceSync sequence = null;
    private volatile boolean executionFlag = false;
    private final Object execSync = new Object();
    private final RequestBuffer requestBuffer = new RequestBuffer();
    private final ConnectionInfoImpl connectionInfo = new ConnectionInfoImpl();
    private final HttpdRequestImpl request = new HttpdRequestImpl();

    private NioPoolThread() {
    }

    public NioPoolThread(HttpReceiveCallback call, ReceiveLinkQueue queue, SequenceSync sequence, int threadId) throws Exception {
        if (call == null || queue == null || sequence == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.call = call;
        this.queue = queue;
        this.sequence = sequence;
        this.threadId = threadId;
        this.startThread();
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        super.stopThread();
        this.executionFlag = false;
    }

    protected void clear() {
        this.queue = null;
        this.call = null;
        this.executionFlag = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean execution() throws Exception {
        NioElement element = null;
        element = this.queue.getQueue();
        if (element == null) return false;
        if (!element.isUse()) return false;
        try {
            Object object = this.execSync;
            synchronized (object) {
                this.executionFlag = true;
            }
            this.executionServer(element);
            Object object2 = this.execSync;
            synchronized (object2) {
                this.executionFlag = false;
                return true;
            }
        }
        catch (Exception e) {
            try {
                if (element != null) {
                    element.destroy();
                }
                element = null;
                throw e;
                catch (Error err) {
                    if (element != null) {
                        element.destroy();
                    }
                    element = null;
                    throw err;
                }
            }
            catch (Throwable throwable) {
                Object object = this.execSync;
                synchronized (object) {
                    this.executionFlag = false;
                    throw throwable;
                }
            }
        }
    }

    protected void toException(Throwable e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExecution() {
        boolean ret;
        Object object = this.execSync;
        synchronized (object) {
            ret = this.executionFlag;
        }
        return ret;
    }

    private void executionServer(NioElement element) throws Exception {
        long time = -1L;
        ConnectionInfo info = null;
        int id = -1;
        try {
            try {
                while (true) {
                    id = this.sequence.getId();
                    info = this.connectionInfo.create(element);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(" ## ***** start " + "receive(" + id + ") - [" + info.getInetAddress().getHostAddress() + ":" + info.getPort() + "] - threadId:" + this.threadId));
                    }
                    if (LOG.isDebugEnabled()) {
                        time = System.currentTimeMillis();
                    }
                    NioPoolThread.readHttpdRequest(this.request, info, this.requestBuffer, id);
                    this.request.setConnectionInfo(info);
                    this.call.execution(info, id, this.request);
                    this.request.clear();
                    if (!info.isComet()) {
                        if (info.isUse()) {
                            if (info.isCloseFlag()) {
                                element.setCloseFlag(true);
                            } else if (!info.recyclingConnection()) {
                                element.setCloseFlag(true);
                            } else {
                                element.setCloseFlag(false);
                            }
                        } else {
                            element.destroy();
                        }
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(" ## @@@@@ end " + "## id[" + id + "]-threadId:" + this.threadId + " " + (System.currentTimeMillis() - time) + "msec"));
                    }
                    if (!element.isBuffer()) {
                        break;
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)"#### pipline - next");
                }
            }
            catch (Exception e) {
                if (element != null) {
                    element.destroy();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(" ## $$$$$ error " + "## id[" + id + "]-threadId:" + this.threadId + " " + (System.currentTimeMillis() - time) + "msec:" + e.getMessage()));
                }
                throw e;
            }
        }
        finally {
            if (info != null) {
                info.clear();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean readHttpdRequest(HttpdRequestImpl request, ConnectionInfo info, RequestBuffer requestBuffer, int seqId) throws Exception {
        if (info == null) throw new IOException("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u60c5\u5831\u306f\u5229\u7528\u3067\u304d\u307e\u305b\u3093");
        if (!info.isUse()) {
            throw new IOException("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u60c5\u5831\u306f\u5229\u7528\u3067\u304d\u307e\u305b\u3093");
        }
        InputStream in = null;
        try {
            in = info.getInputStream(15000L);
            ReadHttpdRequest.receiveHttpRequest(request, in, requestBuffer, seqId);
            return true;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }
}

