/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net.nio;

import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.net.nio.IsReadQueue;
import org.maachang.comet.net.nio.IsWriteQueue;
import org.maachang.comet.net.nio.NioElement;
import org.maachang.comet.net.nio.NioSslUtil;
import org.maachang.comet.net.nio.NioTcpUtil;
import org.maachang.comet.net.nio.ReceiveLinkQueue;
import org.maachang.util.thread.LoopThread;

class NioSslReceiveServer
extends LoopThread {
    private static final Log LOG = LogFactory.getLog(NioSslReceiveServer.class);
    private Selector selector = null;
    private IsReadQueue isRecvQueue = null;
    private IsWriteQueue isWriteQueue = null;
    private ReceiveLinkQueue executionQueue = null;

    private NioSslReceiveServer() {
    }

    public NioSslReceiveServer(ReceiveLinkQueue executionQueue) throws Exception {
        if (executionQueue == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.selector = Selector.open();
        this.isRecvQueue = new IsReadQueue();
        this.isWriteQueue = new IsWriteQueue();
        this.executionQueue = executionQueue;
        this.startThread();
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        super.stopThread();
    }

    public synchronized void setElement(NioElement element) throws Exception {
        element.setIsWriteQueue(this.isWriteQueue);
        this.isRecvQueue.append(element);
        if (this.selector != null && this.selector.isOpen()) {
            this.selector.wakeup();
        }
    }

    protected void clear() {
        if (this.selector != null) {
            try {
                Iterator<SelectionKey> itr = this.selector.keys().iterator();
                while (itr.hasNext()) {
                    try {
                        NioTcpUtil.destroyKey(itr.next());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.selector.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.selector = null;
        this.isRecvQueue = null;
        this.isWriteQueue = null;
        this.executionQueue = null;
    }

    protected boolean execution() throws Exception {
        while (!super.isStop()) {
            NioTcpUtil.isSendOrWrite(this.selector, this.isRecvQueue, this.isWriteQueue);
            while (this.selector.select() > 0) {
                Iterator<SelectionKey> itr = this.selector.selectedKeys().iterator();
                while (itr.hasNext()) {
                    NioTcpUtil.isSendOrWrite(this.selector, this.isRecvQueue, this.isWriteQueue);
                    SelectionKey key = itr.next();
                    itr.remove();
                    if (key == null) continue;
                    if (!key.isValid()) {
                        NioTcpUtil.destroyKey(key);
                        continue;
                    }
                    NioSslUtil.isRead(this.selector, key, this.executionQueue);
                    NioSslUtil.isWrite(this.selector, key, this.executionQueue);
                }
            }
        }
        return true;
    }

    protected void toException(Throwable e) {
        LOG.warn((Object)"error", e);
    }
}

