/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net.nio;

import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.net.nio.IsReadQueue;
import org.maachang.comet.net.nio.IsWriteQueue;
import org.maachang.comet.net.nio.NioElement;
import org.maachang.comet.net.nio.NioReceiveServerArray;
import org.maachang.comet.net.nio.ReceiveBuffer;
import org.maachang.comet.net.nio.ReceiveLinkQueue;

abstract class NioTcpUtil {
    private static final Log LOG = LogFactory.getLog(NioTcpUtil.class);
    private static final int BUFFER = 32768;
    private static final int LINGER = 5;

    private NioTcpUtil() {
    }

    protected static boolean toAcceptBySingle(Selector selector, SelectionKey key, IsWriteQueue queue) throws Exception {
        block8: {
            if ((key.readyOps() & 0x10) == 16) {
                SocketChannel sc = null;
                try {
                    ServerSocketChannel ssc = (ServerSocketChannel)key.channel();
                    sc = ssc.accept();
                    if (sc != null) {
                        NioTcpUtil.setOption(sc);
                        NioElement em = new NioElement(sc, queue);
                        SelectionKey regKey = sc.register(selector, 1, em);
                        if (regKey != null) {
                            em.setKey(regKey);
                        } else {
                            em.destroy();
                        }
                    }
                    return true;
                }
                catch (Exception e) {
                    if (sc == null) break block8;
                    try {
                        sc.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return false;
    }

    protected static boolean toAcceptByPlural(SelectionKey key, NioReceiveServerArray recvServer) throws Exception {
        block6: {
            if ((key.readyOps() & 0x10) == 16) {
                SocketChannel sc = null;
                try {
                    ServerSocketChannel ssc = (ServerSocketChannel)key.channel();
                    sc = ssc.accept();
                    if (sc != null) {
                        NioTcpUtil.setOption(sc);
                        recvServer.setElement(new NioElement(sc));
                    }
                    return true;
                }
                catch (Exception e) {
                    if (sc == null) break block6;
                    try {
                        sc.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return false;
    }

    protected static boolean isRead(boolean mode, Selector selector, SelectionKey key, ReceiveLinkQueue queue, ByteBuffer buffer) throws Exception {
        if ((key.readyOps() & 1) == 1) {
            NioElement em = NioTcpUtil.getNioElement(key);
            if (em == null) {
                return true;
            }
            try {
                if (mode) {
                    if (!NioTcpUtil.recvAll(em, buffer)) {
                        em.destroy();
                        return true;
                    }
                } else if (!NioTcpUtil.recv(em, buffer)) {
                    em.destroy();
                    return true;
                }
                if (!em.isExecutionFlag()) {
                    em.setExecutionFlag(true);
                    queue.append(em);
                }
                key.interestOps(key.interestOps() & 0xFFFFFFFB);
                return true;
            }
            catch (Exception e) {
                if (em != null) {
                    em.destroy();
                }
                return true;
            }
        }
        return false;
    }

    protected static boolean isWrite(Selector selector, SelectionKey key) throws Exception {
        if (key.isValid() && (key.readyOps() & 4) == 4) {
            NioElement em = NioTcpUtil.getNioElement(key);
            if (em == null) {
                return true;
            }
            try {
                ByteBuffer buf = em.getWriteBuffer();
                if (buf != null) {
                    if (buf.limit() == 0) {
                        if (em.isCloseFlag()) {
                            em.destroy();
                            return true;
                        }
                        key.interestOps(key.interestOps() & 0xFFFFFFFB);
                    } else {
                        SocketChannel ch = em.getChannel();
                        ch.write(buf);
                    }
                } else {
                    key.interestOps(key.interestOps() & 0xFFFFFFFB);
                }
                return true;
            }
            catch (Exception e) {
                LOG.error((Object)"tcp@writeError", (Throwable)e);
                if (em != null) {
                    em.destroy();
                }
                return true;
            }
        }
        return false;
    }

    protected static void setOption(SocketChannel channel) throws Exception {
        channel.configureBlocking(false);
        Socket soc = channel.socket();
        soc.setSendBufferSize(32768);
        soc.setReceiveBufferSize(32768);
        soc.setKeepAlive(true);
        soc.setTcpNoDelay(true);
        soc.setReuseAddress(true);
        soc.setSoLinger(true, 5);
    }

    protected static void isSendOrWrite(Selector selector, IsReadQueue read, IsWriteQueue write) throws Exception {
        NioElement element;
        if (read.size() > 0) {
            while ((element = read.getQueue()) != null) {
                if (!element.isUse()) continue;
                SelectionKey key = element.getChannel().register(selector, 1, element);
                if (key != null) {
                    element.setKey(key);
                    continue;
                }
                element.destroy();
            }
        }
        if (write.size() > 0) {
            while ((element = write.getQueue()) != null) {
                if (!element.isUse() || element.getKey() == null) continue;
                element.getKey().interestOps(element.getKey().interestOps() | 4);
            }
        }
    }

    protected static void isWrite(IsWriteQueue queue) throws Exception {
        if (queue.size() > 0) {
            NioElement element;
            while ((element = queue.getQueue()) != null) {
                if (!element.isUse() || element.getKey() == null) continue;
                element.getKey().interestOps(element.getKey().interestOps() | 4);
            }
        }
    }

    protected static void destroyKey(SelectionKey key) {
        NioElement em = (NioElement)key.attachment();
        if (em == null) {
            try {
                key.channel().close();
            }
            catch (Exception exception) {}
        } else {
            em.destroy();
        }
        key.cancel();
    }

    protected static NioElement getNioElement(SelectionKey key) throws Exception {
        NioElement ret = null;
        ret = (NioElement)key.attachment();
        if (ret == null || !ret.isUse()) {
            if (key.channel() != null) {
                try {
                    key.channel().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            key.attach(null);
            key.cancel();
            return null;
        }
        return ret;
    }

    protected static boolean recv(NioElement emt, ByteBuffer buffer) throws Exception {
        if (!emt.isUse()) {
            return false;
        }
        ReceiveBuffer emtBuf = emt.getBuffer();
        SocketChannel channel = emt.getChannel();
        buffer.clear();
        int len = channel.read(buffer);
        if (len <= 0) {
            return false;
        }
        buffer.flip();
        emtBuf.put(buffer);
        emt.update();
        return true;
    }

    protected static boolean recvAll(NioElement emt, ByteBuffer buffer) throws Exception {
        ReceiveBuffer emtBuf = emt.getBuffer();
        SocketChannel channel = emt.getChannel();
        boolean flg = false;
        while (emt.isUse()) {
            buffer.clear();
            int len = channel.read(buffer);
            if (len <= 0) {
                return flg && len > -1;
            }
            buffer.flip();
            emtBuf.put(buffer);
            emt.update();
            flg = true;
        }
        return false;
    }
}

