/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import org.maachang.comet.net.nio.NioElement;
import org.maachang.comet.net.nio.ReceiveBuffer;
import org.maachang.comet.net.ssl.CloseSslException;
import org.maachang.comet.net.ssl.SslUtil;

public class SslElement {
    private NioElement element = null;
    private SSLEngine sslEngine = null;
    private int defaultSize = -1;
    private ByteBuffer netInBuffer = null;
    private ByteBuffer netOutBuffer = null;
    private ByteBuffer recvBuffer = null;
    private SSLEngineResult.HandshakeStatus handShakeState = null;
    private volatile boolean isHandShakeFinish = false;
    private volatile boolean isClose = false;
    private volatile boolean isExitHandShakeSend = false;
    private int recvBufferSize = -1;
    private Object sync = null;

    private SslElement() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SslElement(NioElement element, SSLEngine sslEngine) throws Exception {
        if (sslEngine == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        Object object = element.getSync();
        synchronized (object) {
            this.recvBufferSize = sslEngine.getSession().getApplicationBufferSize();
            this.defaultSize = (int)((float)sslEngine.getSession().getPacketBufferSize() * 1.5f);
            this.recvBuffer = ByteBuffer.allocate(this.recvBufferSize);
            this.netInBuffer = ByteBuffer.allocate(this.defaultSize);
            this.netOutBuffer = ByteBuffer.allocate(this.defaultSize);
            this.netOutBuffer.limit(0);
            this.sslEngine = sslEngine;
            this.element = element;
            this.isHandShakeFinish = false;
            this.isExitHandShakeSend = false;
            this.isClose = false;
            this.sslEngine.beginHandshake();
            this.sync = element.getSync();
            String[] supportCiphers = sslEngine.getSupportedCipherSuites();
            if (supportCiphers != null) {
                sslEngine.setEnabledCipherSuites(supportCiphers);
            }
        }
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.sync;
        synchronized (object) {
            if (this.sslEngine != null) {
                try {
                    this.sslEngine.closeInbound();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.sslEngine.closeOutbound();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.netInBuffer = null;
            this.netOutBuffer = null;
            this.sslEngine = null;
            this.element = null;
            this.recvBuffer = null;
            this.isClose = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        Object object = this.sync;
        synchronized (object) {
            if (this.element != null && this.sslEngine != null) {
                this.element.restartWrite();
                this.sslEngine.closeInbound();
                this.sslEngine.closeOutbound();
                SSLEngineResult res = SslUtil.wrap(this.sslEngine, SslUtil.EMPTY_BUFFER, this.netOutBuffer);
                if (res.getStatus() == SSLEngineResult.Status.CLOSED) {
                    this.writeQueue(this.netOutBuffer);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBuffer() {
        Object object = this.sync;
        synchronized (object) {
            if (this.element != null) {
                this.recvBuffer = ByteBuffer.allocate(this.recvBufferSize);
                this.netInBuffer = ByteBuffer.allocate(this.defaultSize);
                this.netOutBuffer = ByteBuffer.allocate(this.defaultSize);
                this.netOutBuffer.limit(0);
            } else {
                this.recvBuffer = null;
                this.netInBuffer = null;
                this.netOutBuffer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        boolean ret;
        Object object = this.sync;
        synchronized (object) {
            ret = this.isClose;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHandShake() {
        boolean ret;
        Object object = this.sync;
        synchronized (object) {
            ret = this.isHandShakeFinish;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEndHandShake() {
        Object object = this.sync;
        synchronized (object) {
            if (this.isHandShakeFinish) {
                this.isExitHandShakeSend = true;
                this.netInBuffer = ByteBuffer.allocate(this.defaultSize);
                this.netOutBuffer = ByteBuffer.allocate(this.defaultSize);
                this.netOutBuffer.limit(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSendEndHandShake() {
        boolean ret;
        Object object = this.sync;
        synchronized (object) {
            ret = this.isExitHandShakeSend;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getRecvBuffer() {
        ByteBuffer ret;
        Object object = this.sync;
        synchronized (object) {
            ret = this.recvBuffer;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handShake(ByteBuffer recvBuf) throws Exception {
        Object object = this.sync;
        synchronized (object) {
            if (this.isClose) {
                throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
            }
            if (this.handShakeState == null) {
                this.sslEngine.beginHandshake();
                this.handShakeState = this.sslEngine.getHandshakeStatus();
            }
            SSLEngineResult result = null;
            if (this.isUseReadData(recvBuf)) {
                if (this.isHandShakeFinish) {
                    throw new IOException("\u30cf\u30f3\u30c9\u30b7\u30a7\u30a4\u30af\u51e6\u7406\u306f\u5b8c\u4e86\u3057\u3066\u3044\u307e\u3059");
                }
                result = SslUtil.unwrap(this.sslEngine, recvBuf, this.netInBuffer);
                this.handShakeState = result.getHandshakeStatus();
                while (result.getStatus() != SSLEngineResult.Status.OK) {
                    if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                        this.netInBuffer = SslUtil.reallocate(this.netInBuffer);
                        result = SslUtil.unwrap(this.sslEngine, recvBuf, this.netInBuffer);
                        this.handShakeState = result.getHandshakeStatus();
                        continue;
                    }
                    throw new IOException("\u4e0d\u660e\u306a\u30b9\u30c6\u30fc\u30bf\u30b9[" + (Object)((Object)this.handShakeState) + "/" + (Object)((Object)result.getStatus()) + "]\u304c\u8fd4\u3055\u308c\u307e\u3057\u305f");
                }
            } else {
                return;
            }
            boolean roopEnd = true;
            block10: while (roopEnd) {
                switch (this.handShakeState) {
                    case NEED_WRAP: {
                        result = SslUtil.wrap(this.sslEngine, SslUtil.EMPTY_BUFFER, this.netOutBuffer);
                        this.handShakeState = result.getHandshakeStatus();
                        if (result.getStatus() == SSLEngineResult.Status.OK) {
                            this.writeQueue(this.netOutBuffer);
                            if (this.handShakeState != SSLEngineResult.HandshakeStatus.NEED_UNWRAP) continue block10;
                            roopEnd = false;
                            break;
                        }
                        throw new IOException("\u4e0d\u660e\u306a\u30b9\u30c6\u30fc\u30bf\u30b9[" + (Object)((Object)this.handShakeState) + "/" + (Object)((Object)result.getStatus()) + "]\u304c\u8fd4\u3055\u308c\u307e\u3057\u305f");
                    }
                    case NEED_UNWRAP: {
                        if (this.isUseReadData(recvBuf)) {
                            while (true) {
                                result = SslUtil.unwrap(this.sslEngine, recvBuf, this.netInBuffer);
                                this.handShakeState = result.getHandshakeStatus();
                                if (result.getStatus() != SSLEngineResult.Status.BUFFER_OVERFLOW) continue block10;
                                this.netInBuffer = SslUtil.reallocate(this.netInBuffer);
                            }
                        }
                        if (this.handShakeState != SSLEngineResult.HandshakeStatus.NEED_UNWRAP || this.isUseReadData(recvBuf)) continue block10;
                        roopEnd = false;
                        break;
                    }
                    case NEED_TASK: {
                        this.handShakeState = this.tasks();
                        break;
                    }
                    case FINISHED: {
                        this.isHandShakeFinish = true;
                        roopEnd = false;
                        break;
                    }
                    default: {
                        throw new IOException("\u4e0d\u660e\u306a\u30b9\u30c6\u30fc\u30bf\u30b9[" + (Object)((Object)this.handShakeState) + "]\u304c\u8fd4\u3055\u308c\u307e\u3057\u305f");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUseReadData(ByteBuffer recvBuf) {
        boolean ret;
        Object object = this.sync;
        synchronized (object) {
            boolean bl = ret = recvBuf.position() != 0 && recvBuf.hasRemaining() && this.handShakeState == SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
            if (!ret) {
                ret = recvBuf.position() == recvBuf.capacity();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean read(ByteBuffer recvBuf) throws Exception {
        boolean ret = false;
        Object object = this.sync;
        synchronized (object) {
            this.checkExitHandShake();
            ReceiveBuffer emtBuf = this.element.getBuffer();
            SocketChannel channel = this.element.getChannel();
            int len = channel.read(recvBuf);
            if (len <= 0) {
                try {
                    this.sslEngine.closeInbound();
                }
                catch (IOException iOException) {}
            } else {
                this.readToSslConvert(emtBuf, recvBuf);
                this.element.update();
                ret = true;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readTo(ByteBuffer recvBuf) throws Exception {
        boolean ret = false;
        Object object = this.sync;
        synchronized (object) {
            if (recvBuf.position() != 0 && recvBuf.hasRemaining()) {
                ReceiveBuffer emtBuf = this.element.getBuffer();
                while (recvBuf.position() != 0 && recvBuf.hasRemaining()) {
                    int ln = this.readToSslConvert(emtBuf, recvBuf);
                    ret = true;
                    if (ln <= 0) break;
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ByteBuffer buf) throws Exception {
        Object object = this.sync;
        synchronized (object) {
            this.checkExitHandShake();
            int written = 0;
            SSLEngineResult result = SslUtil.wrap(this.sslEngine, buf, this.netOutBuffer);
            written = result.bytesConsumed();
            if (result.getStatus() == SSLEngineResult.Status.OK) {
                if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    this.tasks();
                }
            } else {
                if (result.getStatus() == SSLEngineResult.Status.CLOSED) {
                    throw new CloseSslException("SSL\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u30af\u30ed\u30fc\u30ba");
                }
                throw new IOException("\u4e0d\u6b63\u306a\u30b9\u30c6\u30fc\u30bf\u30b9[" + (Object)((Object)result.getStatus()) + "]\u3092\u691c\u77e5\u3057\u307e\u3057\u305f");
            }
            this.element.getChannel().write(this.netOutBuffer);
            if (buf.limit() != written) {
                buf.position(written);
                buf.compact();
                this.element.setWriteBufferHead(buf);
            }
        }
    }

    private void checkExitHandShake() throws Exception {
        if (this.isClose) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        if (!this.isExitHandShakeSend) {
            throw new IOException("\u30cf\u30f3\u30c9\u30b7\u30a7\u30a4\u30af\u51e6\u7406\u304c\u7d42\u4e86\u3057\u3066\u3044\u307e\u305b\u3093");
        }
    }

    private SSLEngineResult.HandshakeStatus tasks() {
        Runnable r = null;
        while ((r = this.sslEngine.getDelegatedTask()) != null) {
            r.run();
        }
        return this.sslEngine.getHandshakeStatus();
    }

    private void writeQueue(ByteBuffer buf) {
        if (this.element != null && this.element.isUse()) {
            this.element.setWriteBuffer(SslUtil.copy(this.netOutBuffer));
        }
    }

    private int readToSslConvert(ReceiveBuffer emtBuf, ByteBuffer recvBuf) throws Exception {
        this.netInBuffer.clear();
        int recv = 0;
        do {
            SSLEngineResult unwrap;
            if ((unwrap = SslUtil.unwrap(this.sslEngine, recvBuf, this.netInBuffer)).getStatus() == SSLEngineResult.Status.OK || unwrap.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                recv += unwrap.bytesProduced();
                if (unwrap.getStatus() == SSLEngineResult.Status.OK) {
                    this.netInBuffer.flip();
                    emtBuf.put(this.netInBuffer);
                    this.netInBuffer.clear();
                }
                if (unwrap.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    this.tasks();
                }
                if (unwrap.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW) continue;
                break;
            }
            if (unwrap.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW && recv > 0 || unwrap.getStatus() == SSLEngineResult.Status.CLOSED || unwrap.getStatus() == SSLEngineResult.Status.CLOSED) break;
            throw new IOException("\u4e0d\u6b63\u306a\u30b9\u30c6\u30fc\u30bf\u30b9[" + (Object)((Object)unwrap.getStatus()) + "]\u3092\u691c\u77e5\u3057\u307e\u3057\u305f");
        } while (recv != 0);
        return recv;
    }
}

