/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.LittleEndian;

public class DrawingRecord
extends Record {
    public static final short sid = 236;
    private byte[] recordData;
    private byte[] contd;

    public DrawingRecord() {
    }

    public DrawingRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 236) {
            throw new RecordFormatException("Not a MSODRAWING record");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.recordData = in.readRemainder();
    }

    public void processContinueRecord(byte[] record) {
        this.contd = record;
    }

    public int serialize(int offset, byte[] data) {
        if (this.recordData == null) {
            this.recordData = new byte[0];
        }
        LittleEndian.putShort(data, 0 + offset, (short)236);
        LittleEndian.putShort(data, 2 + offset, (short)this.recordData.length);
        if (this.recordData.length > 0) {
            System.arraycopy(this.recordData, 0, data, 4 + offset, this.recordData.length);
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        int retval = 4;
        if (this.recordData != null) {
            retval += this.recordData.length;
        }
        return retval;
    }

    public short getSid() {
        return 236;
    }

    public byte[] getData() {
        if (this.contd != null) {
            byte[] newBuffer = new byte[this.recordData.length + this.contd.length];
            System.arraycopy(this.recordData, 0, newBuffer, 0, this.recordData.length);
            System.arraycopy(this.contd, 0, newBuffer, this.recordData.length, this.contd.length);
            return newBuffer;
        }
        return this.recordData;
    }

    public void setData(byte[] thedata) {
        this.recordData = thedata;
    }

    public Object clone() {
        DrawingRecord rec = new DrawingRecord();
        if (this.recordData != null) {
            rec.recordData = new byte[this.recordData.length];
            System.arraycopy(this.recordData, 0, rec.recordData, 0, this.recordData.length);
        }
        if (this.contd != null) {
            System.arraycopy(this.contd, 0, rec.contd, 0, this.contd.length);
            rec.contd = new byte[this.contd.length];
        }
        return rec;
    }
}

