/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.service.client;

import java.net.InetAddress;
import org.maachang.connector.ClientConnectorFactory;
import org.maachang.dbm.MDbm;
import org.maachang.dbm.MDbmOp;
import org.maachang.dbm.service.ProtocolDef;
import org.maachang.dbm.service.client.MDbmConnection;
import org.maachang.dbm.service.client.MDbmOpConnection;

public class MDbmDriverManager {
    private static final int TIMEOUT = 30000;
    private static final int POOL = 15;

    public static final MDbm getConnection(String addr) throws Exception {
        return MDbmDriverManager.getConnection(addr, -1);
    }

    public static final MDbm getConnection(InetAddress addr) throws Exception {
        return MDbmDriverManager.getConnection(addr, -1);
    }

    public static final MDbm getConnection(String addr, int port) throws Exception {
        if (addr == null) {
            addr = "127.0.0.1";
        }
        return MDbmDriverManager.getConnection(InetAddress.getByName(addr), port);
    }

    public static final MDbm getConnection(InetAddress addr, int port) throws Exception {
        if (addr == null) {
            addr = InetAddress.getByName("127.0.0.1");
        }
        if (port < 0 || port >= 65535) {
            port = 3953;
        }
        return new MDbmConnection(ClientConnectorFactory.getPoolingConnector((byte[])ProtocolDef.PROTOCOL_HEADER, (InetAddress)addr, (int)port, (int)30000, (int)15));
    }

    public static final MDbmOp getConnectionOp(String addr) throws Exception {
        return new MDbmOpConnection(MDbmDriverManager.getConnection(addr, -1));
    }

    public static final MDbmOp getConnectionOp(InetAddress addr) throws Exception {
        return new MDbmOpConnection(MDbmDriverManager.getConnection(addr, -1));
    }

    public static final MDbmOp getConnectionOp(String addr, int port) throws Exception {
        return new MDbmOpConnection(MDbmDriverManager.getConnection(addr, port));
    }

    public static final MDbmOp getConnectionOp(InetAddress addr, int port) throws Exception {
        return new MDbmOpConnection(MDbmDriverManager.getConnection(addr, port));
    }
}

