/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.connector;

import java.io.IOException;
import java.net.InetAddress;
import org.maachang.connector.ClientConnector;
import org.maachang.connector.OneUseClientConnector;

class PoolingClientConnector
implements ClientConnector {
    private InetAddress addr = null;
    private int port = -1;
    private OneUseClientConnector[] pool = null;

    private PoolingClientConnector() {
    }

    public PoolingClientConnector(byte[] headerBinary, InetAddress addr, int port, int timeout, int pooling) throws Exception {
        if (headerBinary == null || headerBinary.length <= 0) {
            throw new IllegalArgumentException("\u30d8\u30c3\u30c0\u30d0\u30a4\u30ca\u30ea\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (addr == null) {
            throw new IllegalArgumentException("\u63a5\u7d9a\u5148\u30a2\u30c9\u30ec\u30b9\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (port <= -1 || port >= 65536) {
            throw new IllegalArgumentException("\u63a5\u7d9a\u5148\u30dd\u30fc\u30c8\u756a\u53f7\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (timeout <= 0) {
            timeout = 30000;
        }
        if (pooling <= 0) {
            pooling = 15;
        } else if (pooling <= 5) {
            pooling = 5;
        } else if (pooling >= 100) {
            pooling = 100;
        }
        this.addr = addr;
        this.port = port;
        OneUseClientConnector[] pl = new OneUseClientConnector[pooling];
        int i = 0;
        while (i < pooling) {
            pl[i] = new OneUseClientConnector(headerBinary, addr, port, timeout);
            ++i;
        }
        this.pool = pl;
    }

    protected void finalize() throws Exception {
        this.close();
    }

    public synchronized void close() {
        if (this.pool != null) {
            int len = this.pool.length;
            int i = 0;
            while (i < len) {
                this.pool[i].destroy();
                ++i;
            }
        }
        this.pool = null;
        this.addr = null;
        this.port = -1;
    }

    public synchronized InetAddress getInetAddress() throws Exception {
        return this.addr;
    }

    public synchronized int getPort() throws Exception {
        return this.port;
    }

    public byte[] sendReceive(byte[] binary) throws Exception {
        if (this.isClosed()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (binary == null || binary.length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        OneUseClientConnector cc = null;
        while ((cc = this.getUseConnect()) == null) {
            Thread.sleep(50L);
        }
        byte[] ret = null;
        try {
            ret = cc.getConnector().sendReceive(binary);
        }
        finally {
            cc.release();
        }
        return ret;
    }

    public synchronized boolean isClosed() {
        return this.pool == null;
    }

    private synchronized OneUseClientConnector getUseConnect() throws Exception {
        if (this.isClosed()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        int len = this.pool.length;
        int i = 0;
        while (i < len) {
            if (!this.pool[i].isUseFlag()) {
                this.pool[i].setUseFlag(true);
                return this.pool[i];
            }
            ++i;
        }
        return null;
    }
}

