/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.maachang.util.Os;
import org.maachang.util.RunProcess;

public abstract class EnvName {
    private EnvName() {
    }

    public static final String getEnv(String name) throws Exception {
        if (name == null || (name = name.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        switch (Os.getInstance().getOS()) {
            case 33: {
                return EnvName.getEnvNt(name);
            }
            case 1: 
            case 66: {
                return EnvName.getEnvUnix(name);
            }
        }
        throw new IOException("\u5b9f\u884c\u4e2d\u306eOS\u3067\u306f\u5229\u7528\u3067\u304d\u307e\u305b\u3093");
    }

    private static final String getEnvNt(String name) throws Exception {
        String ret = null;
        String[] cmd = new String[]{"cmd", "/c", "echo %" + name + "%"};
        RunProcess runProc = new RunProcess(cmd);
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(runProc.execution()));
            String s = reader.readLine();
            if (s != null) {
                ret = s;
            }
            runProc.waitFor();
        }
        finally {
            runProc.destroy();
        }
        return ret;
    }

    private static final String getEnvUnix(String name) throws Exception {
        String ret = null;
        String[] cmd = new String[]{"/bin/sh", "-c", "/bin/echo ${" + name + "}"};
        RunProcess runProc = new RunProcess(cmd);
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(runProc.execution()));
            String s = reader.readLine();
            if (s != null) {
                ret = s;
            }
            runProc.waitFor();
        }
        finally {
            runProc.destroy();
        }
        return ret;
    }

    public static final void main(String[] args) throws Exception {
        BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            System.out.print("env>");
            String name = r.readLine();
            if (name == null) break;
            if ((name = name.trim()).length() <= 0) continue;
            System.out.println("[" + name + "]:" + EnvName.getEnv(name));
        }
    }
}

