/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util.net;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.util.FileUtil;
import org.maachang.util.Os;
import org.maachang.util.RunProcess;

public abstract class ChangeIp {
    private static final Log LOG = LogFactory.getLog(ChangeIp.class);
    private static final Object sync = new Object();

    private ChangeIp() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void change(String name, String addr, String mask, String gateway, String dns) throws Exception {
        if (name == null || (name = name.trim()).length() <= 0 || addr == null || (addr = addr.trim()).length() <= 0 || mask == null || (mask = mask.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        Object object = sync;
        synchronized (object) {
            String[] cmd;
            switch (Os.getInstance().getOS()) {
                case 33: {
                    StringBuilder b = new StringBuilder();
                    b.append("netsh interface ip set address \"").append(name).append("\" static ").append(addr).append(" ").append(mask);
                    if (gateway != null && (gateway = gateway.trim()).length() > 0) {
                        b.append(" ").append(gateway).append(" 1 ");
                    } else {
                        b.append(" none ");
                    }
                    if (dns != null && (dns = dns.trim()).length() > 0) {
                        b.append("& ").append("netsh interface ip set dns \"").append(name).append("\" static ").append(dns);
                    }
                    cmd = new String[]{"cmd", "/c", b.toString()};
                    break;
                }
                case 1: 
                case 66: {
                    cmd = new String[]{"/bin/sh", "-c", "/sbin/service network restart"};
                    ChangeIp.changeIfCfg(name, addr, mask, gateway);
                    ChangeIp.changeResolv(dns);
                    break;
                }
                default: {
                    throw new IOException("\u5b9f\u884c\u4e2d\u306eOS\u3067\u306f\u5229\u7528\u3067\u304d\u307e\u305b\u3093");
                }
            }
            RunProcess runProc = new RunProcess(cmd);
            try {
                String s;
                BufferedReader reader = new BufferedReader(new InputStreamReader(runProc.execution()));
                int i = 1;
                while ((s = reader.readLine()) != null) {
                    LOG.info((Object)("[ChangeIp(\u884c:" + i + ")]:" + s));
                    ++i;
                }
                runProc.waitFor();
            }
            finally {
                runProc.destroy();
            }
        }
    }

    private static final void changeIfCfg(String name, String addr, String mask, String gateway) throws Exception {
        String fileName;
        if (gateway == null || (gateway = gateway.trim()).length() <= 0) {
            gateway = null;
        }
        if (!FileUtil.isFileExists(fileName = "/etc/sysconfig/network-scripts/ifcfg-" + name)) {
            throw new IOException("NetworkConfig(" + fileName + ")\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        byte[] b = FileUtil.getFile(fileName);
        FileUtil.setFile("/etc/sysconfig/network-scripts/back.ifcfg-" + name, true, b);
        b = null;
        StringBuilder buf = new StringBuilder();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));
            boolean mkFlg = false;
            boolean gwFlg = false;
            int i = 0;
            while (true) {
                String s;
                if (i != 0) {
                    buf.append("\n");
                }
                if ((s = reader.readLine()) == null) break;
                String x = s.toLowerCase();
                if (x.startsWith("ipaddr=")) {
                    buf.append("IPADDR=").append(addr);
                } else if (x.startsWith("netmask=")) {
                    buf.append("NETMASK=").append(mask);
                    mkFlg = true;
                } else if (x.startsWith("gateway=")) {
                    if (gateway != null) {
                        buf.append("GATEWAY=").append(gateway);
                        gwFlg = true;
                    }
                } else if (s.length() > 0) {
                    buf.append(s);
                }
                ++i;
            }
            reader.close();
            reader = null;
            if (!mkFlg) {
                buf.append("\nNETMASK=").append(mask);
            }
            if (!gwFlg && gateway != null) {
                buf.append("\nGATEWAY=").append(gateway);
            }
            FileUtil.setFileByString(fileName, true, buf.toString(), System.getProperty("file.encoding"));
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static final void changeResolv(String dns) throws Exception {
        String fileName;
        if (dns != null && (dns = dns.trim()).length() <= 0) {
            dns = null;
        }
        if (!FileUtil.isFileExists(fileName = "/etc/resolv.conf")) {
            FileUtil.setFileByString(fileName, true, "nameserver " + dns, System.getProperty("file.encoding"));
            return;
        }
        byte[] b = FileUtil.getFile(fileName);
        FileUtil.setFile(String.valueOf(fileName) + ".back", true, b);
        b = null;
        StringBuilder buf = new StringBuilder();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));
            boolean dnsFlg = false;
            int i = 0;
            while (true) {
                String s;
                if (i != 0) {
                    buf.append("\n");
                }
                if ((s = reader.readLine()) == null) break;
                String x = s.toLowerCase();
                if (x.startsWith("nameserver ")) {
                    if (dns != null) {
                        buf.append("nameserver ").append(dns);
                        dnsFlg = true;
                    }
                } else if (s.length() > 0) {
                    buf.append(s);
                }
                ++i;
            }
            reader.close();
            reader = null;
            if (!dnsFlg && dns != null) {
                buf.append("\nnameserver ").append(dns);
            }
            FileUtil.setFileByString(fileName, true, buf.toString(), System.getProperty("file.encoding"));
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static final void main(String[] args) throws Exception {
        if (args.length < 5) {
            System.out.println("illegal error.");
            System.out.println("1: netName 2: addr 3: mask 4: gateway 5: dns");
            return;
        }
        ChangeIp.change(args[0], args[1], args[2], args[3], args[4]);
    }
}

