/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util.net;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import org.maachang.util.Os;
import org.maachang.util.RunProcess;

public abstract class Ping {
    public static final boolean check(String addr) throws Exception {
        if (addr == null || (addr = addr.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        return Ping.pingCommand(addr);
    }

    public static final boolean check(InetAddress addr) throws Exception {
        if (addr == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        return Ping.pingCommand(addr.getHostAddress());
    }

    private static final boolean pingCommand(String addr) throws Exception {
        switch (Os.getInstance().getOS()) {
            case 33: {
                return Ping.pingCmdNT(addr);
            }
            case 1: 
            case 66: {
                return Ping.pingCmdUnix(addr);
            }
        }
        throw new IOException("\u5b9f\u884c\u4e2d\u306eOS\u3067\u306f\u5229\u7528\u3067\u304d\u307e\u305b\u3093");
    }

    private static final boolean pingCmdNT(String addr) throws Exception {
        String[] cmd = new String[]{"cmd", "/c", "ping -n 1 " + addr};
        RunProcess runProc = new RunProcess(cmd);
        try {
            String s;
            BufferedReader reader = new BufferedReader(new InputStreamReader(runProc.execution()));
            while ((s = reader.readLine()) != null) {
                int p = s.indexOf(" bytes=");
                if (p == -1 || (p = s.indexOf(" time", p)) == -1 || s.indexOf(" TTL=") == -1) continue;
                return true;
            }
            runProc.waitFor();
        }
        finally {
            runProc.destroy();
        }
        return false;
    }

    private static final boolean pingCmdUnix(String addr) throws Exception {
        String[] cmd = new String[]{"/bin/sh", "-c", "/bin/ping -n -c 1 " + addr};
        RunProcess runProc = new RunProcess(cmd);
        try {
            String s;
            BufferedReader reader = new BufferedReader(new InputStreamReader(runProc.execution()));
            while ((s = reader.readLine()) != null) {
                int p = s.indexOf(": icmp_seq=");
                if (p == -1 || (p = s.indexOf(" ttl=", p)) == -1 || s.indexOf(" time=", p) == -1) continue;
                return true;
            }
            runProc.waitFor();
        }
        finally {
            runProc.destroy();
        }
        return false;
    }

    public static final void main(String[] args) throws Exception {
        BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            System.out.print("IP>");
            String addr = r.readLine();
            if (addr == null) break;
            if ((addr = addr.trim()).length() <= 0) continue;
            System.out.println("[" + addr + "]:" + Ping.check(addr));
        }
    }
}

