// ユーティリティ関連.
//

Utils = function() {}

// 指定日付情報から、年齢を計算.
Utils.calcAge = function( birthDate ) {
    if( isNull( date ) || valueof( date ) != "date" ) {
        return "" ;
    }
    var now = new Date() ;
    var ret = now.getFullYear() - birthDate.getFullYear() ;
    if( now.getMonth() < birthDate.getMonth() ) {
        ret -- ;
    }
    else if( now.getMonth() == birthDate.getMonth() ) {
        if( now.getDate() < birthDate.getDate() ) {
            ret -- ;
        }
        else if( now.getDate() == birthDate.getDate() ) {
            if( now.getHours() < birthDate.getHours() ) {
                ret -- ;
            }
            else if( now.getHours() == birthDate.getHours() ) {
                if( now.getMinutes() < birthDate.getMinutes() ) {
                    ret -- ;
                }
                else if( now.getMinutes() == birthDate.getMinutes() ) {
                    if( now.getSeconds() < birthDate.getSeconds() ) {
                        ret -- ;
                    }
                }
            }
        }
    }
    return ret ;
}

// 指定日から、対象日までの日数を計算.
Utils.bitweenDate = function( src,dest ) {
    if( valueof( src ) != 'date' || valueof( dest ) != 'date' ) {
        return "" ;
    }
    var res = dest.getTime() - src.getTime() ;
    return parseInt( ( ( res / ( 24*60*60*1000) ) + 0.5 ) ) ;
}

