package org.maachang.dbm.engine ;

/**
 * 次キー内容取得用オブジェクト.
 * 
 * @version 2008/01/16
 * @author masahito suzuki
 * @since MaachangDBM 1.00
 */
public class MDbmDefine {
    
    /**
     * MDBMバージョン.
     */
    public static final String VERSION = "b1.14" ;
    
    /**
     * シーケンスサイズ.
     */
    public static final int MAX_SEQUENCE_ID = 64 ;
    
    /**
     * セクタヘッダ.
     */
    public static final int SECTOR_HEADER = 16 ;
    
    /**
     * セクタタイプ : Normal.
     */
    public static final int SECTOR_TYPE_NORMAL = 0x000203a1 ;
    
    /**
     * セクタタイプ : Key.
     */
    public static final int SECTOR_TYPE_KEY = 0x000004e7 ;
    
    /**
     * 初期化ログ出力モード.
     */
    public static boolean OUT_MODE = true ;
    
    /**
     * Hashプロパティ名.
     */
    public static final String HASH_PROPERTY = "mdbm.hash" ;
    
    /**
     * Hashデフォルト値.
     */
    public static final int DEF_HASH= 20 ;
    
    /**
     * Hash最小値.
     */
    public static final int MIN_HASH= 8 ;
    
    /**
     * Hash最大値.
     */
    public static final int MAX_HASH= 26 ;
    
    /**
     * 1ファイルで管理できるセクタプロパティ名.
     */
    public static final String ONE_FILE_SECTOR_PROPERTY = "mdbm.sector.file" ;
    
    /**
     * 1ファイルで扱えるデフォルトセクタ数.
     */
    public static final int DEF_ONE_FILE_SECTOR= 500000 ;
    
    /**
     * 1ファイルで扱える最小セクタ数.
     */
    public static final int MIN_ONE_FILE_SECTOR= 10000 ;
    
    /**
     * 1ファイルで扱える最大セクタ数.
     */
    public static final int MAX_ONE_FILE_SECTOR= 3500000 ;
    
}
