package org.maachang.comet.down ;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.State;
import org.maachang.comet.conf.StartupConfig;
import org.maachang.comet.httpd.engine.StartupHttpdEngine;
import org.maachang.comet.httpd.engine.script.ExecutionStartup;
import org.maachang.shutdown.ShutdownCallback;

/**
 * サーバシャットダウン.
 *
 * @version 2007/11/17
 * @author  masahito suzuki
 * @since   MaachangComet 1.00
 */
public class ShutdownServer extends ShutdownCallback {
    
    /**
     * LOG.
     */
    private static final Log LOG = LogFactory.getLog( ShutdownServer.class ) ;
    
    /**
     * シャットダウン実行.
     * <BR><BR>
     * シャットダウンを実行するコールバックメソッド.
     */
    public void execution() {
        State.getInstance().state( State.IS_SHUTDOWN ) ;// シャットダウン中に設定.
        // startupScriptの終了処理を実行.
        LOG.info( "### [shotdown] - startupScript ... [start]" ) ;
        ExecutionStartup.destroy() ;
        LOG.info( "### [shotdown] - startupScript ... [end]" ) ;
        
        // HttpdEngineサービスを破棄.
        LOG.info( "### [shotdown] - HttpdEngine ..... [start]" ) ;
        StartupHttpdEngine.destroy() ;
        LOG.info( "### [shotdown] - HttpdEngine ..... [end]" ) ;
        
        // 基本サービスを破棄.
        LOG.info( "### [shotdown] - base ............ [start]" ) ;
        StartupConfig.destroy() ;
        LOG.info( "### [shotdown] - base ............ [end]" ) ;
        
        // シャットダウン完了.
        super.exitShutdown() ;
    }
    
}
