package org.maachang.comet.httpd;

import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * HTTPDレスポンス.
 * 
 * @version 2007/08/26
 * @author masahito suzuki
 * @since MaachangComet 1.00
 */
public interface HttpdResponse {
    
    /**
     * オブジェクトを破棄.
     * <BR><BR>
     * オブジェクトを破棄します.
     */
    public void destroy() ;
    
    /**
     * 出力完了処理.
     * <BR><BR>
     * 出力を完了する処理を実施します.
     */
    public void flush() ;
    
    /**
     * HTTPコードを設定.
     * <BR><BR>
     * HTTPコードを設定します.
     * <BR>
     * @param state 対象のHTTPコードを設定します.
     */
    public void setState( int state ) ;
    
    /**
     * HTTPコードを取得.
     * <BR><BR>
     * HTTPコードを取得します.
     * <BR>
     * @return int HTTPコードが返されます.
     */
    public int getState() ;
    
    /**
     * HTTPバージョン情報を設定.
     * <BR><BR>
     * HTTPバージョン情報を設定します.
     * <BR>
     * @param version 対象のHTTPバージョンを設定します.
     */
    public void setVersion( String version ) ;
    
    /**
     * HTTPバージョン情報を取得.
     * <BR><BR>
     * HTTPバージョン情報を取得します.
     * <BR>
     * @return String 対象のHTTPバージョンが返されます.
     */
    public String getVersion() ;
    
    /**
     * GZIP圧縮条件を設定.
     * <BR><BR>
     * GZIP圧縮条件を設定します.
     * <BR>
     * @param flag GZIP圧縮条件を設定します.
     */
    public void setGzip( boolean flag ) ;
    
    /**
     * GZIP圧縮条件を取得.
     * <BR><BR>
     * GZIP圧縮条件を取得します.
     * <BR>
     * @return boolean GZIP圧縮条件が返されます.
     */
    public boolean getGzip() ;
    
    /**
     * HTTPキャッシュ条件を設定.
     * <BR><BR>
     * HTTPキャッシュ条件を設定します.
     * <BR>
     * @param cache HTTPキャッシュ条件を設定します.
     */
    public void setHttpCache( boolean cache ) ;
    
    /**
     * HTTPキャッシュ条件を取得.
     * <BR><BR>
     * HTTPキャッシュ条件を取得します.
     * <BR>
     * @return boolean HTTPキャッシュ条件が返されます.
     */
    public boolean getHttpCache() ;
    
    /**
     * リクエストに設定されているSessionCookie条件を設定.
     * <BR><BR>
     * リクエストに設定されているSessionCookie条件を設定します.
     * <BR>
     * @param request 対象のリクエストを設定します.
     * @exception Exception 例外.
     */
    public void setCookieSession( HttpdRequest request )
        throws Exception ;
    
    /**
     * ヘッダオブジェクトを取得.
     * <BR><BR>
     * ヘッダオブジェクトを取得します.
     * <BR>
     * @return HttpdHeaders ヘッダオブジェクトが返されます.
     */
    public HttpdHeaders getHeader() ;
    
    /**
     * ソケットクローズフラグを設定.
     * <BR><BR>
     * 送信結果と同時に、ソケットをクローズする場合は、[true]を設定します.
     * <BR>
     * @param mode [true]の場合、このオブジェクトが破棄されると同時に、コネクションが切断されます.
     */
    public void setDestroyByClose( boolean mode ) ;
    
    /**
     * リクエストKeepAliveモードを取得.
     * <BR><BR>
     * リクエストKeepAliveモードを取得します.
     * <BR>
     * @return boolean [true]の場合リクエストのKeepAliveは有効です.
     */
    public boolean isRequestKeepAlive() ;
    
    /**
     * HTTPクローズ条件を設定.
     * <BR><BR>
     * HTTPクローズ条件を設定します.
     * <BR>
     * @param closeFlag HTTPクローズ条件を設定します.
     */
    public void setHttpClose( boolean closeFlag ) ;
    
    /**
     * HTTPクローズ条件を取得.
     * <BR><BR>
     * HTTPクローズ条件を取得します.
     * <BR>
     * @return boolean HTTPクローズ条件が返されます.
     */
    public boolean getHttpClose() ;
    
    /**
     * 戻り情報を設定するオブジェクトを取得.
     * <BR><BR>
     * 戻り情報を設定するオブジェクトを取得します.
     * <BR>
     * @return OutputStream 戻り情報を設定するオブジェクトが返されます.
     * @exception Exception 例外
     */
    public OutputStream getOutput()
        throws Exception ;
    
    /**
     * 戻り情報を設定するPrintWriterを取得.
     * <BR><BR>
     * 戻り情報を設定するPrintWriterを取得します.
     * <BR>
     * @return PrintWriter 戻り情報を設定するオブジェクトが返されます.
     * @exception Exception 例外
     */
    public PrintWriter getPrint()
        throws Exception ;
    
    /**
     * OutputStreamが展開されているかチェック.
     * <BR><BR>
     * OutputStreamが展開されているかチェックします.
     * <BR>
     * @return boolean [true]の場合、展開されています.
     */
    public boolean isOutputStream() ;
}
