package org.maachang.comet.httpd.engine.script.dao;

/**
 * マスターキャッシュ子オブジェクト.
 * 
 * @version 2008/07/14
 * @author masahito suzuki
 * @since MaachangComet 1.1F
 */
public class MasterCacheChild {
    private Object value = null ;
    private long lastAccessTime = -1L ;
    
    public MasterCacheChild() {
        
    }
    
    public MasterCacheChild( Object value ) {
        if( value == null ) {
            this.value = null ;
            this.lastAccessTime = -1L ;
        }
        else {
            this.value = value ;
            this.lastAccessTime = System.currentTimeMillis() ;
        }
    }
    
    public synchronized void clearValue() {
        value = null ;
        lastAccessTime = -1L ;
    }
    
    public synchronized void setValue( Object value ) {
        if( value == null ) {
            this.value = null ;
            this.lastAccessTime = -1L ;
        }
        else {
            this.value = value ;
            this.lastAccessTime = System.currentTimeMillis() ;
        }
    }
    
    public synchronized Object getValue() {
        lastAccessTime = System.currentTimeMillis() ;
        return value ;
    }
    
    public synchronized long getLastAccessTime() {
        return lastAccessTime ;
    }
    
    public synchronized boolean isNoValue() {
        return ( value == null ) ? true : false ;
    }
}
