// 基本スクリプト.
//

// 終了条件系.
_$_$exit$of$flag$_$_ = false ;
_$_$exit$of$result$_$_ = "" ;

// グローバル.
_$global = this ;

////////////////////////////////////////////////////////////////////////////////
// ScriptContextScope定義.
////////////////////////////////////////////////////////////////////////////////
var ENGINE_SCOPE = 100 ;
var GLOBAL_SCOPE = 200 ;

////////////////////////////////////////////////////////////////////////////////
// path系.
////////////////////////////////////////////////////////////////////////////////

// 現在読み込みスクリプト名を取得.
currentName = function() {
    return _$current$name ;
} ;

// カレントパスを取得.
currentPath = function() {
    return _$path$currentPath ;
} ;

// スクリプトパスを取得.
scriptPath = function() {
    return _$path$scriptPath ;
} ;

// モデルパスを取得.
modelPath = function() {
    return _$path$modelPath ;
} ;

////////////////////////////////////////////////////////////////////////////////
// 基本系.
////////////////////////////////////////////////////////////////////////////////

// Java変換を行う.
toJava = function( obj ) {
    return org.maachang.jsr.script.javascript.RhinoScriptEngine.nativeTo( obj ) ;
}

// タイプに合わせて内容を変換.
//parseValue = function( value ) {
//    if( isNull( value ) ) {
//        return null ;
//    }
//    var t = valueof( value ) ;
//    if( t == "number" || t == "string" ) {
//        var x = convertString( value ).toLowerCase() ;
//        if( x == "true" || x == "false" ) {
//            if( x == "true" ) {
//                return true ;
//            }
//            return false ;
//        }
//        if( t == "string" ) {
//            value = convertString( value ) ;
//        }
//        if( isNumeric( value ) == true ) {
//            //if( isDouble( value ) == false ) {
//            //    return java.lang.Integer.parseInt(value);
//            //}
//            if( t == "string" ) {
//                if( startsWith( value,"0" ) == true && value.length > 1 ) {
//                    return value ;
//                }
//            }
//            return parseInt(value) ;
//        }
//        else if( startsWith( value,"__$formatter@date@=" ) ) {
//            return new Date( parseInt( value.substring( "__$formatter@date@=".length,value.length ) ) ) ;
//        }
//        else {
//            return value ;
//        }
//    }
//    else if( t == "object" ) {
//        var clz = className( value ) ;
//        if( clz == 'Boolean' ) {
//            if( value == true || value == false ) {
//                if( value == true ) {
//                    return true ;
//                }
//                else {
//                    return false ;
//                }
//            }
//        }
//        if( clz == 'Short' || clz == 'Integer' ||
//            clz == 'Long' || clz == 'Double' ||
//            clz == 'Float' ) {
//            //if( isDouble( value ) == false ) {
//            //    return java.lang.Integer.parseInt(value);
//            //}
//            value = parseInt(convertString(value)) ;
//        }
//        else if( clz == 'String' ) {
//            value = convertString( value ) ;
//            if( startsWith( value,"__$formatter@date@=" ) ) {
//                value = new Date( parseInt( value.substring( "__$formatter@date@=".length,value.length ) ) ) ;
//            }
//            return value ;
//        }
//    }
//    else if( t == "boolean" ) {
//        if( value == true || value == false ) {
//            if( value == true ) {
//                return true ;
//            }
//            else {
//                return false ;
//            }
//        }
//    }
//    return value ;
//} ;

// 整数に変換.
//parseNumber = function(num) {
//    if( isNumeric( num ) == false ) {
//        return 0 ;
//    }
//    //return parseInt( num ) ;
//    return new java.lang.Long( num ) ;
//}

// 指定内容に対して、情報が存在するかチェックする.
useEmpty = function( value ) {
    if( isNull( value ) ) {
        return false ;
    }
    if( value instanceof org.maachang.comet.httpd.HttpdBinary ) {
        value = value.getBinary() ;
    }
    return ( isEmpty( value ) == false ) ;
}

// タイプに合わせて内容を変換.
parseValue = function( value ) {
    if( isNull( value ) ) {
        return null ;
    }
    var clz = className( value ) ;
    if( clz == "String" || clz == "NativeString" ) {
        if( startsWith( value,"__$formatter@date@=" ) ) {
            if( clz == "String" && typeof( value ) == "object" ) {
                return new Date( parseInt( value.substring( "__$formatter@date@=".length,value.length() ) ) ) ;
            }
            else {
                return new Date( parseInt( value.substring( "__$formatter@date@=".length,value.length ) ) ) ;
            }
        }
    }
    return _parseValue( value ) ;
}

// trim.
//trim = function(str){
//    if( isNull( str ) ) {
//        return null ;
//    }
//    return convertString( org.maachang.util.StringUtil.trim( convertString( str ) ) ) ;
//} ;

// toLowerCase.
toLowerCase = function(str){
    if( isNull( str ) ) {
        return null ;
    }
    str = convertString( str ) ;
    return str.toLowerCase() ;
} ;

// toUpperCase.
toUpperCase = function(str){
    if( isNull( str ) ) {
        return null ;
    }
    str = convertString( str ) ;
    return str.toUpperCase() ;
} ;

// startWith.
//startsWith = function(str,chk) {
//    if( isNull( str ) || isNull( chk ) ) {
//        return false ;
//    }
//    if( convertString( str ).indexOf( convertString( chk ) ) == 0 ) {
//        return true ;
//    }
//    return false ;
//} ;

// endsWith.
//endsWith = function(str,chk) {
//    if( isNull( str ) || isNull( chk ) ) {
//        return false ;
//    }
//    str = convertString( str ) ;
//    chk = convertString( chk );
//    var last = str.lastIndexOf( chk ) ;
//    if( last != -1 && last == str.length-chk.length ) {
//        return true ;
//    }
//    return false ;
//} ;

// 指定文字列を置き換える.
//changeString = function(str,src,dest) {
//    return convertString( org.maachang.util.StringUtil.changeString( str,src,dest ) ) ;
//}

// 文字列連結オブジェクト.
StrBuf = function() {}
StrBuf.prototype = {
    // buffer.
    buf: null,
    // 生成処理.
    create: function(len) {
        if( isNull( len ) || typeof(len) != "number" || len <= 0 ) {
            this.buf = new java.lang.StringBuilder() ;
        }
        else {
            this.buf = new java.lang.StringBuilder(len) ;
        }
        return this ;
    },
    // クリア処理.
    clear: function() {
        this.buf = null ;
        return this ;
    },
    // 連結.
    append: function(str) {
        if( isNull( str ) ) {
            return ;
        }
        if( isNull( this.buf ) ) {
            this.create() ;
        }
        this.buf.append( convertString( str ) ) ;
        return this ;
    },
    // 連結.
    ad: function( str ) {
        return this.append( convertString( str ) ) ;
    },
    // 長さを取得.
    length: function() {
        if( isNull( this.buf ) ) {
            return 0 ;
        }
        return parseInt( this.buf.length() ) ;
    },
    // 内容表示.
    toString: function() {
        if( isNull( this.buf ) ) {
            return null ;
        }
        return String( this.buf.toString() ) ;
    },
    // 連結情報出力.
    ts : function() {
        if( isNull( this.buf ) ) {
            return null ;
        }
        return String( this.buf.toString() ) ;
    },
    // 連結情報出力.
    toBuffer: function() {
        if( isNull( this.buf ) ) {
            return null ;
        }
        return String( this.buf.toString() ) ;
    }
} ;
var StringBuffer = StrBuf ;

// maachangCometバージョン取得.
version = function() {
    return convertString( org.maachang.comet.httpd.HttpdVersionDef.getVersion() ) ;
} ;

// maachangComet更新日取得.
update = function() {
    return convertString( org.maachang.comet.httpd.HttpdVersionDef.getDate() ) ;
} ;

// データベースが利用可能かチェック.
isDatabase = function() {
    if( isNull( _$$maachang_comet_manager.get( "DBMS_POOL" ) ) ) {
        return false ;
    }
    return true ;
}

// bindingsを取得.
bindings = function(scope) {
    if( isNull( _$script$context ) ) {
        return null ;
    }
    if( isNull( scope ) ) {
        scope = ENGINE_SCOPE ;
    }
    return _$script$context.getBindings( scope ) ;
}

// スクリプトキャッシュリロード.
reload = function() {
    org.maachang.comet.httpd.engine.script.cache.CacheScriptManager.getInstance().reload() ;
} ;

// スクリプトタイプを取得.
getScriptType = function() {
    if( isNull( __$type$script ) ) {
        return null ;
    }
    return __$type$script ;
} ;

// スクリプト詳細を取得.
getScriptDetail = function() {
    if( isNull( __$detail$script ) ) {
        return null ;
    }
    return __$detail$script ;
} ;

// eval実装用をセット.
_eval = function(script){
    if( isNull( _$script$context ) ) {
        return null ;
    }
    if( isNull( script ) || isNull( _$script$engine ) ) {
        return null ;
    }
    return _$script$engine.eval(script,_$script$context ) ;
} ;
eval = function( script ) {
    return _eval( script ) ;
} ;

// スクリプト強制終了用.
_exit = function(result){
    if( isNull( result ) ) {
        result = "" ;
    }
    _$_$exit$of$flag$_$_ = true ;
    _$_$exit$of$result$_$_ = result ;
    org.maachang.comet.httpd.engine.script.EndScript.exit() ;
} ;
exit = function(result){
    _exit(result) ;
} ;

// try{}catch()で取得した例外が、スクリプト強制終了例外の場合はThrowする.
_isExitTo = function() {
    if( isNull( _$_$exit$of$flag$_$_ ) == false && _$_$exit$of$flag$_$_ == true ) {
        org.maachang.comet.httpd.engine.script.EndScript.exit() ;
    }
} ;

// Bindingsセット.
putBindings = function( key,value ) {
    if( isNull( _$script$context ) ) {
        return ;
    }
    if( useString( key ) == true && isNull( value ) == false ) {
        _$script$context.getBindings( ENGINE_SCOPE ).put( key,value ) ;
    }
}

// Bindings削除.
removeBindings = function( key ) {
    if( isNull( _$script$context ) ) {
        return ;
    }
    if( useString( key ) == true ) {
        _$script$context.getBindings( ENGINE_SCOPE ).remove( key ) ;
    }
}

// Bindings取得.
getBindings = function( key ) {
    if( isNull( _$script$context ) ) {
        return null ;
    }
    if( useString( key ) == true ) {
        return _$script$context.getBindings( ENGINE_SCOPE ).get( key ) ;
    }
    return null ;
}

// jmap.
jmap = function(map) {
    if( isNull( map ) ) {
        map = new java.util.HashMap() ;
    }
    return new JSAdapter({
        __get__ : function(name) {
            if( name == "__getJSAdapterType" ) {
                return "map" ;
            }
            else if( name == "core" ) {
                return map ;
            }
            else if( name == "empty" ) {
                return ( map.size() <= 0 ) ;
            }
            else if (map.containsKey(name)) {
                var ret = map.get(name) ;
                if( isNull( ret ) == false && ret instanceof org.maachang.comet.httpd.HttpdBinary ) {
                    return ret.getOriginalName() ;
                }
                else {
                    return parseValue( ret ) ;
                }
            }
            else if( name == "toString" ) {
                var ret = new StrBuf().ad( "{" ) ;
                var it = map.keySet().iterator() ;
                var cnt = 0 ;
                while( it.hasNext() ) {
                    if( cnt != 0 ) {
                        ret.ad( " ," ) ;
                    }
                    var x = it.next() ;
                    var v = map.get( x ) ;
                    if( isNull( v ) == false ) {
                        var clz = className( v ) ;
                        if( clz == "JSAdapter" || clz == "NativeArray" || clz == "NativeObject" ) {
                            ret.ad( x ).ad( ": " ).ad( "\"" ).ad( v.toString ).ad( "\"" ) ;
                        }
                        else if( clz == "NativeDate" ) {
                            ret.ad( x ).ad( ": " ).ad( "\"" ).ad( formatDateByCustomString( v," " ) ).ad( "\"" ) ;
                        }
                        else {
                            ret.ad( x ).ad( ": " ).ad( "\"" ).ad( v ).ad( "\"" ) ;
                        }
                    }
                    else {
                        ret.ad( x ).ad( ": \"\"" ) ;
                    }
                    cnt ++ ;
                }
                ret.ad( "}" ) ;
                return ret.ts() ;
            }
            else {
                return "";
            }
          },
        __has__ :  function(name) {
            if( name == "toString" || name == "__getJSAdapterType" || name == "core" || name == "empty" ) {
                    return true ;
                }
                return map.containsKey(name);
            },
        __delete__ : function (name) {
                return map.remove(name);
            },
        __put__ : function(name, value) {
                if( name == "toString" || name == "__getJSAdapterType" || name == "core" || name == "empty" ) {
                    return false ;
                }
                map.put(name,value);
                return true ;
            },
        __getIds__ : function() {
            var ret = [] ;
            var o = map.keySet().iterator() ;
            while( o.hasNext() ) {
                ret[ ret.length ] = o.next() ;
            }
            return ret ;
            },
        toString: function() {
            var ret = new StrBuf().ad( "{" ) ;
            var it = map.keySet().iterator() ;
            var cnt = 0 ;
            while( it.hasNext() ) {
                if( cnt != 0 ) {
                    ret.ad( " ," ) ;
                }
                var x = it.next() ;
                var v = map.get( x ) ;
                if( isNull( v ) == false ) {
                    var clz = className( v ) ;
                    if( clz == "JSAdapter" || clz == "NativeArray" || clz == "NativeObject" ) {
                        ret.ad( x ).ad( ": " ).ad( "\"" ).ad( v.toString ).ad( "\"" ) ;
                    }
                    else if( clz == "NativeDate" ) {
                        ret.ad( x ).ad( ": " ).ad( "\"" ).ad( formatDateByCustomString( v," " ) ).ad( "\"" ) ;
                    }
                    else {
                        ret.ad( x ).ad( ": " ).ad( "\"" ).ad( v ).ad( "\"" ) ;
                    }
                }
                else {
                    ret.ad( x ).ad( ": \"\"" ) ;
                }
                cnt ++ ;
            }
            ret.ad( "}" ) ;
            return ret.ts() ;
        },
        __getJSAdapterType: function() {
            return "map" ;
        },
        core: function() {
            return map ;
        },
        empty: function() {
            return ( map.size() <= 0 ) ;
        }
    });
} ;

// jlist.
jlist = function(list) {
    if( isNull( list ) ) {
        list = new java.util.ArrayList() ;
    }
    function isValid(index) {
        return typeof(index) == 'number' &&
            index > -1 && index < list.size();
    }
    return new JSAdapter({
        __get__ :  function(name) {
            if( name == "__getJSAdapterType" ) {
                return "array" ;
            }
            else if( name == "core" ) {
                return list ;
            }
            else if( name == "empty" ) {
                return ( list.size() <= 0 ) ;
            }
            else if( name == "toString" ) {
                var ret = new StrBuf().ad( "[" ) ;
                var len = list.size() ;
                var cnt = 0 ;
                for (var i = 0; i < len; i++) {
                    var v = list.get( i ) ;
                    if( cnt != 0 ) {
                        ret.ad( "," ) ;
                    }
                    if( isNull( v ) == false ) {
                        var clz = className( v ) ;
                        if( clz == "JSAdapter" || clz == "NativeArray" || clz == "NativeObject" ) {
                            ret.ad( v.toString ) ;
                        }
                        else if( className( ret ) == "NativeDate" ) {
                            ret.ad( formatDateByCustomString( v," " ) ) ;
                        }
                        else {
                            ret.ad( v ) ;
                        }
                    }
                    cnt ++ ;
                }
                ret.ad( "]" ) ;
                return ret.ts();
            }
            else if( name == "length" ) {
                var ret = list.size() ;
                if( isNull( ret ) == true ) {
                    return null ;
                }
                else if( useString( ret ) == false ) {
                    return "" ;
                }
                return parseValue(ret) ;
            }
            else if (isValid(name)) {
                var ret = list.get(name);
                return parseValue( ret ) ;
            }
            else {
                return null;
            }
        },
        __has__ : function (name) {
            return isValid(name) || name == "__getJSAdapterType" || name == 'length' ||
                name == 'toString' || name == 'core' || name == "empty" ;
        },
        __delete__ : function(name) {
            if (isValid(name)) {
                list.remove(name);
            }
        },
        __put__ : function(name, value) {
            if( name == "__getJSAdapterType" || name == 'length' || name == 'toString' || name == 'core' || name == "empty" ) {
                return false ;
            }
            if (isValid(name)) {
                list.set(name,value);
                return true ;
            }
            return false ;
        },
        __getIds__: function() {
            var res = new Array(list.size());
            for (var i = 0; i < res.length; i++) {
                res[i] = i;
            }
            return res;
        },
        toString: function() {
            var ret = new StrBuf().ad( "[" ) ;
            var len = list.size() ;
            var cnt = 0 ;
            for (var i = 0; i < len; i++) {
                var v = list.get( i ) ;
                if( cnt != 0 ) {
                    ret.ad( "," ) ;
                }
                if( isNull( v ) == false ) {
                    var clz = className( v ) ;
                    if( clz == "JSAdapter" || clz == "NativeArray" || clz == "NativeObject" ) {
                        ret.ad( v.toString ) ;
                    }
                    else if( className( ret ) == "NativeDate" ) {
                        ret.ad( formatDateByCustomString( v," " ) ) ;
                    }
                    else {
                        ret.ad( v ) ;
                    }
                }
                cnt ++ ;
            }
            ret.ad( "]" ) ;
            return ret.ts();
        },
        length: function() {
            var ret =list.size() ;
            if( isNull( ret ) == true ) {
                return null ;
            }
            else if( useString( ret ) == false ) {
                return "" ;
            }
            return parseValue(ret) ;
        },
        __getJSAdapterType: function() {
            return "array" ;
        },
        core: function() {
            return list ;
        },
        empty: function() {
            return ( list.size() <= 0 ) ;
        }
    });
} ;

// ガページコレクターを実行.
gc = function() {
    java.lang.Runtime.getRuntime().gc() ;
} ;

// システム系.
MSys = {
    // 最大アクセス数.
    getNetUsePooling : function(){
        return org.maachang.comet.MSystem.getNetUsePooling() ;
    },
    // アクティブアクセス数.
    getNetActivePooling : function(){
        return org.maachang.comet.MSystem.getNetActivePooling() ;
    },
    // トータルメモリを取得.
    mtotal : function() {
        return java.lang.Runtime.getRuntime().totalMemory() ;
    },
    // 最大メモリを取得.
    mmax : function() {
        return java.lang.Runtime.getRuntime().maxMemory() ;
    },
    // 空きメモリを取得.
    mfree : function() {
        return java.lang.Runtime.getRuntime().freeMemory() ;
    },
    // CPU利用率を取得.
    useCpu : function() {
        return org.maachang.comet.MSystem.useCpu() ;
    },
    // プロセスIDを取得.
    getProcessId : function() {
        return org.maachang.comet.MSystem.getProcessId() ;
    },
    // ステータスを取得.
    state : function() {
        return String( org.maachang.comet.State.getInstance().toString() ) ;
    }
}

// 数値(小数点)チェック.
isDouble = function(num){
    if( isNull( num ) ) {
        return false ;
    }
    num = convertString( num ) ;
    if( useString( num ) == false ) {
        return false ;
    }
    if( startsWith( num,"-" ) == true ) {
        num = num.substring( 1 ) ;
    }
    if( num.match(/[^0-9]/g) ) {
        return false ;
    }
    else if (num.match(/[^0-9.0-9]/g)) {
        return true;
    }
    return false ;
} ;

// 小数点を含む場合の桁あわせ処理.
viewDouble = function( v,num,mode ) {
    if( isNumeric( num ) == false ) {
        return v ;
    }
    if( isNull( num ) || num <= 0 ) {
        return String(parseInt( v )) ;
    }
    if( isNull( mode ) == false && ( mode == true || mode == "true" ) ) {
        mode = true ;
    }
    else {
        mode = false ;
    }
    v = String( v ) ;
    var len = v.length ;
    var p = v.indexOf( "." ) ;
    if( p <= -1 ) {
        v += "." ;
        for( var i = 0 ; i < num ; i ++ ) {
            v += "0" ;
        }
        return v ;
    }
    var flt = len - (p+1) ;
    if( num <= flt ) {
        var x ;
        if( mode ) {
            x = v.substring( len-(flt-num)+1,len-(flt-num) ) ;
            if( parseInt( x ) >= 5 ) {
                var numLen = num ;
                var x = 1 ;
                for( var i = 0 ; i < numLen ; i ++ ) {
                    x = x * 0.1 ;
                }
                if( startsWith( v,"-" ) ) {
                    v = String( Number( v ) - Number( x ) ) ;
                }
                else {
                    v = String( Number( v ) + Number( x ) ) ;
                }
                flt = len - (v.indexOf( "." )+1) ;
            }
        }
        v = v.substring( 0,len-(flt-num) ) ;
    }
    else {
        len = num-flt ;
        for( var i = 0 ; i < len ; i ++ ) {
            v += "0" ;
        }
    }
    
    return v ;
}

// 指定内容をプリミティブ型に変換.
convertPrimitive = function(type,value) {
    if( isNull( type ) || isNull( value ) ) {
        return null ;
    }
    return org.maachang.comet.httpd.engine.script.js.JsDef.convertPrimitive( type,value ) ;
} ;

// wait時間をセット.
sleep = function(time) {
    if( isNull( time ) ) {
        return ;
    }
    java.lang.Thread.sleep( time );
} ;

// alert偽造.
alert = function(str){
    println( str );
} ;

// println偽造.
p = function(str){
    println( str ) ;
} ;

// println偽装.
puts = function(str) {
    println( str ) ;
} ;

// Javaオブジェクト配列長を取得.
arrayLength = function(objs) {
    if( isNull( objs ) ) {
        return -1 ;
    }
    return parseInt( org.maachang.comet.httpd.engine.script.js.JsDef.arrayLength( objs ) ) ;
} ;

// javaオブジェクト配列の指定位置情報を取得.
getArray = function(objs,no) {
    if( isNull( objs ) || isNull( no ) ) {
        return null ;
    }
    return org.maachang.comet.httpd.engine.script.js.JsDef.getArray( objs,no ) ;
} ;

// javaオブジェクト配列の指定位置情報を取得.
setArray = function(objs,no,value) {
    if( isNull( objs ) || isNull( no ) || isNull( value ) ) {
        return null ;
    }
    return org.maachang.comet.httpd.engine.script.js.JsDef.setArray( objs,no,value ) ;
} ;

// 指定文字列をバイナリに変換.
convertStringByBinary = function( string,charset ) {
    if( isNull( string ) ) {
        string = null ;
    }
    if( isNull( charset ) ) {
        charset = null ;
    }
    return org.maachang.comet.httpd.engine.script.js.JsDef.convertStringByBinary( string,charset ) ;
} ;

// 指定バイナリを文字列に変換.
convertBinaryByString = function( binary,charset ) {
    if( isNull( binary ) ) {
        binary = null ;
    }
    if( isNull( charset ) ) {
        charset = null ;
    }
    return org.maachang.comet.httpd.engine.script.js.JsDef.convertBinaryByString( binary,charset ) ;
} ;

// 新しいバイナリ情報を生成.
createBinary = function( size ) {
    return org.maachang.comet.httpd.engine.script.js.JsDef.createBinary( size ) ;
} ;

// バイナリ内容を表示形式に変換.
toBinaryString = function( binary ) {
    if( isNull( binary ) ) {
        binary = null ;
    }
    return convertString( org.maachang.comet.httpd.engine.script.js.JsDef.toBinaryString( binary ) ) ;
} ;

// バイナリ長を取得.
binaryLength = function(objs) {
    if( isNull( objs ) ) {
        return -1 ;
    }
    return parseInt( org.maachang.comet.httpd.engine.script.js.JsDef.binaryLength( objs ) ) ;
} ;

// バイナリの情報を取得.
getBinary = function(objs,no) {
    if( isNull( objs ) || isNull( no ) ) {
        return null ;
    }
    return org.maachang.comet.httpd.engine.script.js.JsDef.getBinary( objs,no ) ;
} ;


// バイナリ情報に設定.
setBinary = function(objs,no,value) {
    if( isNull( value ) ) {
        return null ;
    }
    if( typeof( value ) == 'number' ) {
        return org.maachang.comet.httpd.engine.script.js.JsDef.setBinaryByByte( objs,no,value ) ;
    }
    return org.maachang.comet.httpd.engine.script.js.JsDef.setBinary( objs,no,convertString( value ) ) ;
} ;

// バイナリ情報かチェック.
isBinary = function( value ) {
    if( isNull( value ) ) {
        return false ;
    }
    if( className( value ) == "[B" ) {
        return true ;
    }
    return false ;
    //return org.maachang.comet.httpd.engine.script.js.JsDef.isBinary( value ) ;
} ;

// Base64エンコード.
encodeBase64 = function(binary){
    if( isNull( binary ) ) {
        return null ;
    }
    return convertString( org.maachang.util.Base64.encode(binary) ) ;
} ;

// Base64デコード.
decodeBase64 = function(str){
    if( isNull( str ) ) {
        return null ;
    }
    return org.maachang.util.Base64.decode(str);
} ;

// 金額表示(円).
formatYen = function( val ) {
    if( isNull( val ) || isNumeric( val ) == false ) {
        return val ;
    }
    val = String( val ) ;
    var len = val.length ;
    var ret = "" ;
    var cnt = 0 ;
    for( var i = len-1 ; i >= 0 ; i -- ) {
        if( cnt >= 3 ) {
            ret = "," + ret ;
            cnt = 0 ;
        }
        ret = val.charAt( i ) + ret ;
        cnt ++ ;
    }
    return ret ;
}

// 指定フォーマットに対して文字列から数値変換(simpleDateFormat).
parseFormatDate = function(format,value) {
    if( isNull( format ) || isNull( value ) ) {
        return null ;
    }
    return org.maachang.comet.httpd.engine.script.js.JsDef.convertDateFormatByString( format,value ) ;
} ;

// 指定フォーマットに対して数値から文字列変換(simpelDateFormat).
formatDate = function(format,value) {
    var tm = dateParse( format,value ) ;
    if( isNull( tm ) ) {
        return null ;
    }
    return new Date().setTime( tm ) ;
} ;

// 現在日付を取得.
nowDate = function( mode ) {
    return formatDateByString( new Date(),mode )
} ;

// 現在日付を取得.
dateToString = function( mode ) {
    return formatDateByString( new Date(),mode )
} ;

// 現在日付を取得.
date = function() {
    println( dateToString() ) ;
} ;

// 日付を変換.
formatDateByString = function( date,mode ) {
    if( isNull( date ) ) {
        return null ;
    }
    if( isNull( mode ) ) {
        mode = false ;
    }
    var buf = new StringBuffer() ;
    buf.append( date.getFullYear()  ) ;
    var x = convertString(date.getMonth()+1) ;
    buf.append( "/" ).append( "00".substring( x.length,2 ) ).append( x ) ;
    x = convertString( date.getDate() ) ;
    buf.append( "/" ).append( "00".substring( x.length,2 ) ).append( x ) ;
    if( mode == true ) {
        if( __$type$script == "console" ) {
            buf.append( " " ) ;
        }
        else {
            buf.append( "&nbsp;" ) ;
        }
        x = convertString( date.getHours() ) ;
        buf.append( "00".substring( x.length,2 ) ).append( x ) ;
        x = convertString( date.getMinutes() ) ;
        buf.append( ":" ).append( "00".substring( x.length,2 ) ).append( x ) ;
        x = convertString( date.getSeconds() ) ;
        buf.append( ":" ).append( "00".substring( x.length,2 ) ).append( x ) ;
    }
    return buf.toString() ;
} ;

// 日付を変換.
formatDateByCustomString = function( date,cut ) {
    if( isNull( date ) ) {
        return null ;
    }
    if( isNull( cut ) || useString( cut ) == false ) {
        if( __$type$script == "console" ) {
            cut = " " ;
        }
        else {
            cut = "<br>" ;
        }
    }
    var buf = new StringBuffer() ;
    buf.append( date.getFullYear()  ) ;
    var x = convertString( date.getMonth()+1 ) ;
    buf.append( "/" ).append( "00".substring( x.length,2 ) ).append( x ) ;
    x = convertString( date.getDate() ) ;
    buf.append( "/" ).append( "00".substring( x.length,2 ) ).append( x ) ;
    buf.append( cut ) ;
    x = convertString( date.getHours() ) ;
    buf.append( "00".substring( x.length,2 ) ).append( x ) ;
    x = convertString( date.getMinutes() ) ;
    buf.append( ":" ).append( "00".substring( x.length,2 ) ).append( x ) ;
    x = convertString( date.getSeconds() ) ;
    buf.append( ":" ).append( "00".substring( x.length,2 ) ).append( x ) ;
    return buf.toString() ;
} ;

// 指定ドメインのIPアドレスを取得.
ip = function(name) {
    if( isNull( name ) ) {
        return ;
    }
    var addrs = java.net.InetAddress.getAllByName(name);
    for (var i in addrs) {
        println(addrs[i]);
    }
} ;

// 指定ドメインのIPアドレスを取得.
convertDomainToIp = function(name) {
    if( isNull( name ) ) {
        return [] ;
    }
    var addrs = java.net.InetAddress.getAllByName(name);
    var ret = [] ;
    var cnt = 0 ;
    for (var i in addrs) {
        ret[ cnt ] = addrs[i];
        cnt ++ ;
    }
    return ret ;
} ;

// HTMLに対して表示可能な形式に変換.
convertViewHtml = function(string) {
    if( useString( string ) == false ) {
        return "" ;
    }
    else if( valueof(string) != "string" ) {
        return string ;
    }
    return convertString( org.maachang.comet.httpd.engine.script.js.JsDef.convertByViewHtml( true,string ) ) ;
} ;

// 動的なHTMLタグを含む条件かチェック.
isDirectHtmlTag = function(string) {
    if( useString( string ) == false ) {
        return false ;
    }
    else if( valueof(string) != "string" ) {
        return false ;
    }
    return convertString( org.maachang.comet.httpd.engine.script.js.ConvertTag.isTag( string ) ) ;
} ;

// 動的なHTMLタグを表示可能な形式に変換.
convertDirectHtml = function(string) {
    if( useString( string ) == false ) {
        return "" ;
    }
    else if( valueof(string) != "string" ) {
        return string ;
    }
    return convertString( org.maachang.comet.httpd.engine.script.js.ConvertTag.convert( string ) ) ;
} ;

// 指定文字列の全角内容を半角変換.
convertZenToHan = function(string) {
    if( useString( string ) == false ) {
        return "" ;
    }
    else if( valueof(string) != "string" ) {
        return string ;
    }
    return convertString( org.maachang.util.ZenToHan.convertHankaku( string ) ) ;
}

// 指定コンフィグセクションが存在するかチェック.
isConfigSection = function( section ) {
    if( useString( section ) == false ) {
        return false ;
    }
    var conf = _$$maachang_comet_manager.get( "CONFIG_MANAGER" ) ;
    if( isNull( conf ) ) {
        return false ;
    }
    return conf.getConfig().isSection( section ) ;
}

// 指定コンフィグ内容を取得.
getConfig = function( section,key,no ) {
    var conf = _$$maachang_comet_manager.get( "CONFIG_MANAGER" ) ;
    if( isNull( conf ) ) {
        return null ;
    }
    if( useString( section ) == false || useString( key ) == false ) {
        return null ;
    }
    if( isNull( no ) || isNumeric( no ) == false ) {
        no = 0 ;
    }
    return parseValue( conf.get( section,key,no ) ) ;
} ;

// ランダム文字列を生成.
randomString = function( len,zen,han,num ) {
    return convertString( org.maachang.util.RandomUtil.randomString( len,zen,han,num ) ) ;
}

// 英数に対して、振り仮名を取得.
britishNumberToKana = function( str ) {
    if( useString( str ) == false ) {
        return "" ;
    }
    return convertString( org.maachang.util.EStoKana.convert( str ) ) ;
}

// Map内容をコピー.
copyMap = function( src,dest ) {
    if( isNull( src ) || isNull( dest ) ||
        valueof( src ) != 'map' || valueof( dest ) != 'map' ) {
        return ;
    }
    for( var k in src ) {
        dest[ k ] = src[ k ] ;
    }
}

// Mapを再生成して、コピーした内容を取得.
cloneMap = function( map ) {
    if( isNull( map ) || valueof( map ) != 'map' ) {
        return {} ;
    }
    var ret = {} ;
    for( var k in map ) {
        ret[ k ] = map[ k ] ;
    }
    return ret ;
}

// map内のキーを昇順ソートして取得.
keyMapSort = function( map,mode ) {
    if( isNull( map ) || valueof( map ) != 'map' ) {
        if( isNull( map ) ) {
            return null ;
        }
        return map ;
    }
    var ret = [] ;
    if( mode != true ) {
        if( isNull( map['_$_$sort_key$_$_'] ) ) {
            var lst = new org.maachang.util.ObjectArray() ;
            for( var k in map ) {
                lst.add( new java.lang.String( k ) ) ;
            }
            lst.sort() ;
            var len = parseInt( lst.size() ) ;
            for( var i = 0 ; i < len ; i ++ ) {
                ret[ ret.length ] = convertString( lst.get( i ) ) ;
            }
            lst.clear() ;
            map['_$_$sort_key$_$_'] = ret ;
        }
        else {
            ret = map['_$_$sort_key$_$_'] ;
        }
    }
    else {
        var lst = new org.maachang.util.ObjectArray() ;
        for( var k in map ) {
            lst.add( new java.lang.String( k ) ) ;
        }
        lst.sort() ;
        var len = parseInt( lst.size() ) ;
        for( var i = 0 ; i < len ; i ++ ) {
            ret[ ret.length ] = convertString( lst.get( i ) ) ;
        }
        lst.clear() ;
    }
    return ret ;
}

// データ内容をコンソール出力.
varPrint = function( o,index ) {
    var topFlag = false ;
    if( isNull( index ) || index <= 0 ) {
        index = 1 ;
        topFlag = true ;
    }
    var indSp = "" ;
    if( index > 0 ) {
        for( var i = 0 ; i < index ; i ++ ) {
            indSp += "   " ;
        }
    }
    var t = valueof( o ) ;
    if( topFlag ) {
        print( "[" + t + "]" ) ;
    }
    else {
        print( indSp + "[" + t + "] " ) ;
    }
    switch( t ) {
        case "JSAdapter" :
            println() ;
            break ;
        case "string" :
            println( "\""+o+"\"" ) ;
            break ;
        case "number" :
        case "boolean" :
            println( o ) ;
            break ;
        case "map" :
            println() ;
            for( var k in o ) {
                var tt = valueof( o[k] ) ;
                println( indSp+"*[" + k + "] " ) ;
                varPrint( o[k],index+1 ) ;
            }
            break ;
        case "array" :
            println() ;
            var len = o.length ;
            for( var i = 0 ; i < len ; i ++ ) {
                println( indSp+"*[" + (i+1) + "] " ) ;
                varPrint( o[i],index+1 ) ;
            }
            break ;
        case "date" :
            println( formatDateByCustomString( o ) ) ;
            break ;
        case "binary" :
            println( binaryLength( o ) ) ;
            break ;
        default :
            println( o ) ;
            break ;
    }
}

// 共有メモリオブジェクト.
SharedMemory = {
    put : function( name,value ) {
        _$shared$params.put( name,value ) ;
    },
    remove : function( name ) {
        _$shared$params.remove( name ) ;
    },
    get : function( name ) {
        return _$shared$params.get( name ) ;
    },
    containsKey : function( name ) {
        return _$shared$params.containsKey( name ) ;
    },
    size : function() {
        return _$shared$params.size() ;
    }
} ;

// ネットマスクオブジェクト.
NetMask = function() {}
NetMask.prototype = {
    object: null,
    create: function( addr,mask ) {
        if( useString( addr ) == false ) {
            return false ;
        }
        if( isNull( mask ) ) {
            this.object = new org.maachang.util.NetMask( addr ) ;
        }
        else {
            this.object = new org.maachang.util.NetMask( addr,mask ) ;
        }
        return true ;
    },
    clear: function() {
        this.object = null ;
    },
    getNetworkAddress: function() {
        if( isNull( this.object ) ) {
            return null ;
        }
        return this.object.getNetworkAddress() ;
    },
    getNetMask: function() {
        if( isNull( this.object ) ) {
            return null ;
        }
        return this.object.getNetMask() ;
    },
    isRange: function( addr ) {
        if( isNull( this.object ) || useString( addr ) == false ) {
            return false ;
        }
        return this.object.isRange( addr ) ;
    }
} ;

// bindingsに対するJSAdapter.
/*Bindings = function() {
    var core = bindings() ;
    return JSAdapter({
        __get__ : function (name) {
            if( isNull( name ) ) {
                return null ;
            }
            else if( core.containsKey( name ) ) {
                return core.get( name ) ;
            }
            return null ;
        },
        __has__ : function (name) {
            if( isNull( name ) ) {
                return null ;
            }
            return core.containsKey(name);
        },
        __put__ : function (name, value) {
            if( isNull( name ) || isNull( value ) ) {
                return ;
            }
            else if( value != null ) {
                core.put( name,value ) ;
            } ;
        },
        __delete__ : function (name) {
            if( isNull( name ) ) {
                return ;
            }
            core.remove( name ) ;
        },
        __getIds__ : function () {
            var ret = [] ;
            var o = core.keySet().iterator() ;
            while( o.hasNext() ) {
                ret[ ret.length ] = o.next() ;
            }
            return ret ;
        }
    }) ;
} ;*/

