//
// JSONP-RPCスクリプト.
//

////////////////////////////////////////////////////////////////////////////////
// JSONPスクリプトパターンからコールバックされるメソッド.
////////////////////////////////////////////////////////////////////////////////

_$function$callRPCAccessMethod = function() {
    if( __$type$script == "script" ) {
        if( getHttpMethod() != "GET" ) {
            warnLog( "rpcはHTTP-GETメソッド以外のアクセスを許可していません" ) ;
            exit( "error405" ) ;
        }
        var jargsString = $("jargs") ;
        var callbackMethod = $("callback") ;
        var ret = null ;
        // mainメソッドが存在しない場合.
        if( isNull( scriptMemorys.main ) || valueof( scriptMemorys.main ) != "function" ) {
            warnLog( "mainメソッドは存在しないか不正です" ) ;
            exit( "error500" ) ;
        }
        try {
            // 引数が設定されていない場合.
            if( useString( jargsString ) == false ) {
                ret = scriptMemorys.main() ;
            }
            // 引数が設定されている場合.
            else {
                var args = decodeJSON( jargsString ) ;
                if( args == null ) {
                    ret = scriptMemorys.main() ;
                }
                else {
                    if( valueof( args ) != "array" ) {
                        args = [args] ;
                    }
                    ret = scriptMemorys.main.apply( null,args ) ;
                }
            }
        } catch( e ) {
            _isExitTo() ;// スクリプト終了チェック.
            warnLog( e ) ;// 警告ログ.
            // 例外の場合、例外内容を返す.
            exit( "error500" ) ;
        }
        return jsonpResultCallBack( callbackMethod,ret ) ;
    }
    return "" ;
} ;

// コールバックメソッド呼び出し処理.
jsonpResultCallBack = function( callbackFunc,params ) {
    var res = new StrBuf() ;
    res.ad( callbackFunc ).ad( ".apply(null," ) ;
    if( params != null ) {
        res.ad( encodeResultJSON( params ) ) ;
    }
    res.ad( ") ;\n" ) ;
    return res.ts() ;
}

