package org.maachang.comet.httpd.engine.script.scripts;

import org.maachang.comet.MaachangDef;
import org.maachang.comet.httpd.engine.script.js.InitJS;

/**
 * RPCスクリプト.
 * 
 * @version 2008/05/18
 * @author masahito suzuki
 * @since MaachangComet 1.13
 */
public class RpcScript extends AbstractScript {
    
    private RpcScript() {
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * 条件を指定してオブジェクトを生成します.
     * <BR>
     * @param path 対象のパスを設定します.
     * @param currentDirectory カレントディレクトリを設定します.
     * @exception Exception 例外.
     */
    public RpcScript( String path,String currentDirectory )
        throws Exception {
        this.create( "Rpc",MaachangDef.DIRECTORY_APPLICATION,
            path,currentDirectory ) ;
    }
    
    /**
     * スクリプトタイプを取得.
     * <BR><BR>
     * スクリプトタイプを取得します.
     * <BR>
     * @return int スクリプトタイプが返されます.
     */
    public int getScriptType() {
        return ScriptManager.SCRIPT_TYPE_BY_RPC ;
    }
    
    /**
     * Headerスクリプトを設定.
     */
    protected String addHeaderScript() throws Exception {
        return InitJS.getInstance().get() ;
    }
    
    /**
     * Footerスクリプトを設定.
     */
    protected String addFooterScript() throws Exception {
        StringBuilder fooder = new StringBuilder() ;
        fooder.append( "\n var result = _$function$callRPCAccessMethod() ;\n" ) ;
        // コンテンツタイプはJavascript.
        fooder.append( "setContentType( \"text/javascript\" ) ;\n" ) ;
        fooder.append( "httpPrintln( result ) ;\n" ) ;
        return fooder.toString() ;
    }
}
