package org.maachang.comet.net.nio ;

import java.util.LinkedList;

/**
 * 読み込み可能キュー.
 * 
 * @version 2008/05/28
 * @author  masahito suzuki
 * @since   MaachangComet 1.1B
 */
class IsReadQueue {
    private final LinkedList<NioElement> queue = new LinkedList<NioElement>() ; ;
    
    public IsReadQueue() {
    }
    
    public synchronized void destroy() {
        queue.clear() ;
    }
    
    public synchronized void append( NioElement element ) {
        if( element != null ) {
            queue.add( element ) ;
        }
    }
    
    public synchronized NioElement getQueue() {
        if( queue.size() > 0 ) {
            return queue.removeFirst() ;
        }
        return null ;
    }
    
    public synchronized int size() {
        return queue.size() ;
    }
}
