package org.maachang.report ;

/**
 * １つのセルポジションを表すオブジェクト.
 * 
 * @version 2008/09/29
 * @author masahito suzuki
 * @since MaachangReport 1.00
 */
class CellPosition {
    
    /**
     * X位置.
     */
    private int x = -1 ;
    
    /**
     * Y位置.
     */
    private int y = -1 ;
    
    /**
     * 定義文字列.
     */
    private String name = null ;
    
    /**
     * セルスタイル名.
     */
    private String cellStyleName = null ;
    
    
    /**
     * コンストラクタ.
     */
    public CellPosition() {
        
    }
    
    /**
     * コンストラクタ.
     */
    public CellPosition( int x,int y,String name ) {
        this.x = x ;
        this.y = y ;
        this.name = name ;
        this.cellStyleName = null ;
    }
    
    /**
     * cellStyleName を取得.
     * <BR><BR>
     * @return cellStyleName が返されます.
     */
    public String getCellStyleName() {
        return cellStyleName;
    }
    
    /**
     * cellStyleName を設定.
     * <BR><BR>
     * @param cellStyleName cellStyleName を設定します.
     */
    public void setCellStyleName(String cellStyleName) {
        this.cellStyleName = cellStyleName;
    }
    
    /**
     * name を取得.
     * <BR><BR>
     * @return name が返されます.
     */
    public String getName() {
        return name;
    }
    
    /**
     * name を設定.
     * <BR><BR>
     * @param name name を設定します.
     */
    public void setName(String name) {
        this.name = name;
    }
    
    /**
     * x を取得.
     * <BR><BR>
     * @return x が返されます.
     */
    public int getX() {
        return x;
    }
    
    /**
     * x を設定.
     * <BR><BR>
     * @param x x を設定します.
     */
    public void setX(int x) {
        this.x = x;
    }
    
    /**
     * y を取得.
     * <BR><BR>
     * @return y が返されます.
     */
    public int getY() {
        return y;
    }
    
    /**
     * y を設定.
     * <BR><BR>
     * @param y y を設定します.
     */
    public void setY(int y) {
        this.y = y;
    }
    
    /**
     * 文字列で取得.
     * @return String 文字列で返されます.
     */
    public String toString() {
        return new StringBuilder().
            append( "{name:" ).append( name ).
            append( ", x:" ).append( x ).
            append( ", y:" ).append( y ).
            append( ", cellStyleName:" ).append( cellStyleName ).
            append( "} " ).toString() ;
    }
}

