package org.maachang.report ;


/**
 * セルスタイルBean.
 * 
 * @version 2008/09/29
 * @author masahito suzuki
 * @since MaachangReport 1.00
 */
public class CellStyleBean {
    
    /**
     * セルスタイル名.
     */
    private String name = null ;
    
    /**
     * コピー元の開始軸X.
     */
    private int startX = -1 ;
    
    /**
     * コピー元の開始軸Y.
     */
    private int startY = -1 ;
    
    /**
     * コピーWidth値.
     */
    private int width = -1 ;
    
    /**
     * コピーHeight値.
     */
    private int height = -1 ;
    
    /**
     * コンストラクタ.
     */
    private CellStyleBean() {
        
    }
    
    /**
     * コンストラクタ.
     * @param name セルスタイル名を設定します.
     * @param startXPos コピー開始位置Xを設定します.
     * @param startYPos コピー開始位置Yを設定します.
     * @param width Width値を設定します.
     * @param height Height値を設定します.
     * @exception Exception 例外.
     */
    public CellStyleBean( String name,int startXPos,int startYPos,int width,int height )
        throws Exception {
        if( name == null || ( name = name.trim() ).length() <= 0 ) {
            throw new IllegalArgumentException( "セルスタイル名は不正です" ) ;
        }
        if( startXPos <= -1 || startXPos > 65535 || startYPos <= -1 || startYPos > 65535 ) {
            throw new IllegalArgumentException( "開始ポジションが不正です" ) ;
        }
        if( width <= -1 || width > 65535 || height <= -1 || height > 65535 ) {
            throw new IllegalArgumentException( "コピー範囲が不正です" ) ;
        }
        this.name = name ;
        this.width = width ;
        this.height = height ;
        this.startX = startXPos ;
        this.startY = startYPos ;
    }
    
    /**
     * コンストラクタ.
     * @param name セルスタイル名を設定します.
     * @param startXPos コピー開始位置X(ExcelA-Z座標)を設定します.
     * @param startYPos コピー開始位置Yを設定します.
     * @param width Width値を設定します.
     * @param height Height値を設定します.
     * @exception Exception 例外.
     */
    public CellStyleBean( String name,String startXPos,int startYPos,int width,int height )
        throws Exception {
        this( name,ExcelUtil.getPosAz( startXPos ),startYPos,width,height ) ;
    }
    
    /**
     * Width値を取得.
     * @return int Width値が返されます.
     */
    public int getWidth() {
        return width ;
    }
    
    /**
     * Height値を取得.
     * @return int Height値が返されます.
     */
    public int getHeight() {
        return height ;
    }
    
    /**
     * startX値を取得.
     * @return int startX値が返されます.
     */
    public int getStartX() {
        return startX ;
    }
    
    /**
     * startY値を取得.
     * @return int startY値が返されます.
     */
    public int getStartY() {
        return startY ;
    }
    
    /**
     * セルスタイル名を取得.
     * @return String セルスタイル名が返されます.
     */
    public String getName() {
        return name ;
    }
}

