package org.maachang.report ;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * 範囲選択されたセルスタイル情報管理.
 * 
 * @version 2008/09/29
 * @author masahito suzuki
 * @since MaachangReport 1.00
 */
class CellStyleList {
    
    /**
     * セルスタイルリスト.
     */
    private Map<String,CellStyle> map = null ;
    
    /**
     * コンストラクタ.
     */
    public CellStyleList() {
        this.map = new HashMap<String,CellStyle>() ;
    }
    
    /**
     * 情報クリア.
     */
    public void clear() {
        map.clear() ;
    }
    
    /**
     * セルスタイルを追加.
     * @param cs 対象のセルスタイルを設定します.
     */
    public void put( CellStyle cs ) {
        if( cs == null || cs.isUse() == false ) {
            return ;
        }
        map.put( cs.getName(),cs ) ;
    }
    
    /**
     * 指定名でセルスタイルを取得.
     * @param name 対象の名前を設定します.
     * @return GroupCellStyle セルスタイルが返されます.
     */
    public CellStyle get( String name ) {
        if( name == null || ( name = name.trim() ).length() <= 0 ) {
            throw new IllegalArgumentException( "引数は不正です" ) ;
        }
        return map.get( name ) ;
    }
    
    /**
     * 指定名のセルスタイルが存在するかチェック.
     * @param name 対象の名前を設定します.
     * @return boolean [true]の場合、存在します.
     */
    public boolean containsKey( String name ) {
        if( name == null || ( name = name.trim() ).length() <= 0 ) {
            throw new IllegalArgumentException( "引数は不正です" ) ;
        }
        return map.containsKey( name ) ;
    }
    
    /**
     * 設定されているセルスタイル数を取得.
     * @return int 設定されているセルスタイル数を取得します.
     */
    public int size() {
        return map.size() ;
    }
    
    /**
     * Iteratorを取得.
     * @return Iterator Iteratorが返されます.
     */
    public Iterator iterator() {
        return map.keySet().iterator() ;
    }
}

