package org.maachang.report ;

/**
 * Excelユーティリティ系.
 * 
 * @version 2008/09/29
 * @author masahito suzuki
 * @since MaachangReport 1.00
 */
abstract class ExcelUtil {
    
    /**
     * ExcelA-Z座標を座標数値に変換.
     * @param az ExcelA-Z座標を設定します.
     * @return short 座標値が返されます.
     */
    public static final short getPosAz( String az ) {
        if( az == null || ( ( az = az.trim() ).length() != 0 && az.length() > 2 ) ) {
            return -1 ;
        }
        az = az.toLowerCase() ;
        if( az.length() == 1 ) {
            int x2 = ( int )( az.charAt( 0 ) - 'a' ) ;
            if( x2 < 0 || x2 > 26 ) {
                return -1 ;
            }
            return ( short )(x2) ;
        }
        else {
            int x2 = ( int )( az.charAt( 0 ) - 'a' ) + 1 ;
            if( x2 < 0 || x2 > 26 ) {
                return -1 ;
            }
            int x1 = ( int )( az.charAt( 1 ) - 'a' ) + 1 ;
            if( x1 < 0 || x1 > 26 ) {
                return -1 ;
            }
            return ( short )(x1 + (( x2 * 26 )-1) ) ;
        }
    }
}
