package org.maachang.report ;

/**
 * 帳票要素.
 * 
 * @version 2008/10/01
 * @author masahito suzuki
 * @since MaachangReport 1.00
 */
public class ReportElement {
    
    /**
     * セルタイプ : ブランク(なし).
     */
    public static final int CELL_BLANK = ExcelSheet.CELL_BLANK ;
    
    /**
     * セルタイプ : 数字.
     */
    public static final int CELL_NUMBER = ExcelSheet.CELL_NUMBER ;
    
    /**
     * セルタイプ : 文字.
     */
    public static final int CELL_STRING = ExcelSheet.CELL_STRING ;
    
    /**
     * セルタイプ : Boolean.
     */
    public static final int CELL_BOOLEAN = ExcelSheet.CELL_BOOLEAN ;
    
    /**
     * セルタイプ : 日付.
     */
    public static final int CELL_DATE = ExcelSheet.CELL_DATE ;
    
    /**
     * Excelシート情報.
     */
    private ExcelSheet sheet = null ;
    
    /**
     * コンストラクタ.
     */
    private ReportElement() {
        
    }
    
    /**
     * コンストラクタ.
     * @param sheet Excelシートオブジェクトを設定します.
     */
    protected ReportElement( ExcelSheet sheet ) {
        this.sheet = sheet ;
    }
    
    /**
     * １つのセル情報に設定.
     * @param x 位置X値を設定します.
     * @param y 位置Y値を設定します.
     * @param data 設定情報をセットします.
     * @exception Exception 例外.
     */
    public void setCell( int x,int y,Object data )
        throws Exception {
        sheet.setCell( x,y-1,data ) ;
    }
    
    /**
     * １つのセル情報に設定.
     * @param x 位置X値(ExcelA-Z座標)を設定します.
     * @param y 位置Y値を設定します.
     * @param data 設定情報をセットします.
     * @exception Exception 例外.
     */
    public void setCell( String x,int y,Object data )
        throws Exception {
        setCell( ExcelUtil.getPosAz( x ),y,data ) ;
    }
    
    /**
     * １つのセル内容を取得.
     * @param x 位置X値を設定します.
     * @param y 位置Y値を設定します.
     * @return Object セル内容が返されます.
     * @exception Exception 例外.
     */
    public Object getCell( int x,int y )
        throws Exception {
        return sheet.getCell( x,y-1 ) ;
    }
    
    /**
     * １つのセル内容を取得.
     * @param x 位置X(ExcelA-Z座標)を設定します.
     * @param y 位置Y値を設定します.
     * @return Object セル内容が返されます.
     * @exception Exception 例外.
     */
    public Object getCell( String x,int y )
        throws Exception {
        return getCell( ExcelUtil.getPosAz( x ),y ) ;
    }
    
    /**
     * １つのセルタイプを取得.
     * @param x 位置X値を設定します.
     * @param y 位置Y値を設定します.
     * @return int セルタイプが返されます.
     *             [-1]の場合、取得に失敗したか、不明なタイプです.
     */
    public int getCellType( int x,int y ) {
        return getCellType( x,y-1 ) ;
    }
    
    /**
     * １つのセルタイプを取得.
     * @param x 位置X(ExcelA-Z座標)を設定します.
     * @param y 位置Y値を設定します.
     * @return int セルタイプが返されます.
     *             [-1]の場合、取得に失敗したか、不明なタイプです.
     */
    public Object getCellType( String x,int y ) {
        return getCellType( ExcelUtil.getPosAz( x ),y ) ;
    }
    
    /**
     * ワークシート名を取得.
     * @return String ワークシート名が返されます.
     */
    public String getSheetName() {
        return sheet.getSheetName() ;
    }
    
    /**
     * オブジェクトが有効かチェック.
     * @return boolean [true]の場合、有効です.
     */
    public boolean isUse() {
        return sheet.isUse() ;
    }
}
