package org.maachang.session.server.protocol ;

import org.maachang.util.ConvertParam;

/**
 * エラープロトコル.
 * 
 * @version 2008/05/25
 * @author masahito suzuki
 * @since PersistenceSession 1.00
 */
public class SvErrorProtocol extends ServerProtocol {
    
    /**
     * コンストラクタ.
     */
    public SvErrorProtocol( String message )
        throws Exception {
        byte[] b = null ;
        int len = 0 ;
        if( message != null ) {
            b = message.getBytes( "UTF8" ) ;
            len = b.length ;
        }
        this.result = new byte[ 8 + len ] ;
        int p = 0 ;
        ConvertParam.convertInt( this.result,p,getProtocolType() ) ;
        p += 4 ;
        ConvertParam.convertInt( this.result,p,len ) ;
        p += 4 ;
        if( len > 0 ) {
            System.arraycopy( b,0,this.result,p,len ) ;
        }
    }
    
    /**
     * サーバプロトコルタイプを取得.
     * @return int サーバプロトコルタイプが返されます.
     */
    public int getProtocolType() {
        return TYPE_ERROR ;
    }
    
    /**
     * 処理結果の内容を設定.
     * @param value 処理結果の内容を設定します.
     * @exception Exception 例外.
     */
    public void setResult( Object value ) throws Exception {
    }
}

