package org.maachang.rawio.async ;

import java.util.LinkedList;

/**
 * 書込みデータキュー.
 * 
 * @version 2008/06/12
 * @author  masahito suzuki
 * @since   Rawio 1.00
 */
class ASyncQueue {
    private LinkedList<ASyncElement> queue = null ;
    private int elementSize = 0 ;
    
    public ASyncQueue() {
        queue = new LinkedList<ASyncElement>() ;
    }
    
    public synchronized void destroy() {
        if( queue != null ) {
            queue.clear() ;
        }
        elementSize = 0 ;
    }
    
    public synchronized void append( ASyncElement element ) {
        if( element == null || element == null ) {
            return ;
        }
        queue.add( element ) ;
        elementSize ++ ;
    }
    
    public synchronized ASyncElement getQueue() {
        if( queue == null || queue.size() <= 0 ) {
            return null ;
        }
        return queue.removeFirst() ;
    }
    
    public synchronized void relaseElement() {
        elementSize -- ;
        if( elementSize <= 0 ) {
            elementSize = 0 ;
        }
    }
    
    public synchronized int elementSize() {
        return elementSize ;
    }
}
