/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;

public class OracleSerialBlob
implements Blob,
Serializable,
Cloneable {
    private byte[] buffer;
    private long length;

    public OracleSerialBlob(byte[] byArray) throws SQLException {
        this.length = byArray.length;
        this.buffer = new byte[(int)this.length];
        int n = 0;
        while ((long)n < this.length) {
            this.buffer[n] = byArray[n];
            ++n;
        }
    }

    public OracleSerialBlob(Blob blob) throws SQLException {
        this.length = blob.length();
        this.buffer = new byte[(int)this.length];
        BufferedInputStream bufferedInputStream = new BufferedInputStream(blob.getBinaryStream());
        try {
            int n = 0;
            int n2 = 0;
            do {
                n = bufferedInputStream.read(this.buffer, n2, (int)(this.length - (long)n2));
                n2 += n;
            } while (n > 0);
        }
        catch (IOException iOException) {
            throw new SQLException("SerialBlob: " + iOException.getMessage());
        }
    }

    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.buffer);
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        if (l < 0L || (long)n > this.length || l + (long)n > this.length) {
            throw new SQLException("Invalid Arguments");
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.buffer, (int)l, byArray, 0, n);
        return byArray;
    }

    public long length() throws SQLException {
        return this.length;
    }

    public long position(byte[] byArray, long l) throws SQLException {
        if (l < 0L || l > this.length || l + (long)byArray.length > this.length) {
            throw new SQLException("Invalid Arguments");
        }
        int n = (int)(l - 1L);
        boolean bl = false;
        long l2 = byArray.length;
        if (l < 0L || l > this.length) {
            return -1L;
        }
        while ((long)n < this.length) {
            int n2 = 0;
            long l3 = n + 1;
            while (byArray[n2++] == this.buffer[n++]) {
                if ((long)n2 != l2) continue;
                return l3;
            }
        }
        return -1L;
    }

    public long position(Blob blob, long l) throws SQLException {
        return this.position(blob.getBytes(0L, (int)blob.length()), l);
    }

    public int setBytes(long l, byte[] byArray) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return -1;
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return -1;
    }

    public OutputStream setBinaryStream(long l) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public void truncate(long l) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
    }
}

