/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dao;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.maachang.dao.DaoSession;
import org.maachang.dao.DaoSessionFactory;
import org.maachang.dao.MaachangDaoException;
import org.maachang.dao.dbms.DbUtil;
import org.maachang.dao.dbms.MetaColumn;
import org.maachang.dao.dbms.MetaFactory;
import org.maachang.dao.dbms.Record;
import org.maachang.dao.dbms.ResultUtil;
import org.maachang.dao.dbms.kind.SupportKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionDao {
    private static final String INSERT_BY_SQL = "insert";
    public static final String SEQ_COLUMN = "id";
    public static final String CREATE_TIME = "create_time";
    public static final String UPDATE_TIME = "update_time";
    public static final String OPTIMISTIC_LOCK_COLUMN = "optimistic_lock";
    private static final String MANY_JOIN_NAME = "$";

    public static final int executionSql(Long[] outId, Record record, String model, MetaColumn meta, String sql, Object[] params, int size) throws Exception {
        String s;
        if (record == null) {
            return 0;
        }
        if (sql == null || (sql = sql.trim()).length() <= 0) {
            throw new IllegalArgumentException("SQL\u6587\u306f\u4e0d\u6b63\u3067\u3059");
        }
        SupportKind kind = record.getSupportKind();
        if (kind == null) {
            throw new IOException("\u30b5\u30dd\u30fc\u30c8\u5916\u306e\u30a2\u30c0\u30d7\u30bf\u3067\u3059");
        }
        String lower = sql.toLowerCase();
        boolean insertFlag = lower.startsWith(INSERT_BY_SQL);
        boolean seqFlag = ExecutionDao.isSequence(meta);
        Long seq = null;
        if (outId != null && outId.length >= 1) {
            String s2;
            if (DaoSessionFactory.getInstance().isJavaSequence()) {
                if (params != null && params.length > 0 && params[0] != null && params[0] instanceof Long) {
                    seq = (Long)params[0];
                }
            } else if (seqFlag && insertFlag && (params == null || params.length <= 0 || !(params[0] instanceof Long)) && (s2 = kind.getSequenceId(model)) != null && (seq = ExecutionDao.getSequenceId(record, s2)) != null) {
                params[0] = seq;
            }
        }
        int ret = 0;
        ret = params == null || params.length <= 0 ? record.executeUpdate(sql) : record.executeUpdate(sql, params, size);
        if (outId != null && outId.length >= 1 && !DaoSessionFactory.getInstance().isJavaSequence() && seqFlag && insertFlag && (s = kind.getInsertIdBySQL()) != null) {
            seq = ExecutionDao.getInsertId(record, s);
        }
        if (outId != null) {
            outId[0] = seq;
        }
        return ret;
    }

    public static final int executionCount(Record record, String model, MetaColumn meta, String sql, Object[] params, int size) throws Exception {
        if (record == null) {
            return 0;
        }
        if (sql == null || (sql = sql.trim()).length() <= 0) {
            throw new IllegalArgumentException("SQL\u6587\u306f\u4e0d\u6b63\u3067\u3059");
        }
        SupportKind kind = record.getSupportKind();
        if (kind == null) {
            throw new IOException("\u30b5\u30dd\u30fc\u30c8\u5916\u306e\u30a2\u30c0\u30d7\u30bf\u3067\u3059");
        }
        ResultSet rs = null;
        try {
            rs = params == null || params.length <= 0 ? record.executeQuery(sql) : record.executeQuery(sql, params, size);
            int count = 0;
            if (rs.next()) {
                count = rs.getInt(1);
            }
            rs.close();
            rs = null;
            int n = count;
            return n;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            rs = null;
        }
    }

    public static final List<Map<String, Object>> executionSelect(Record record, String model, MetaColumn meta, String sql, int columnLen, int offset, int limit, Object[] params, int size) throws Exception {
        if (record == null) {
            return null;
        }
        if (sql == null || (sql = sql.trim()).length() <= 0) {
            throw new IllegalArgumentException("SQL\u6587\u306f\u4e0d\u6b63\u3067\u3059");
        }
        SupportKind kind = record.getSupportKind();
        if (kind == null) {
            throw new IOException("\u30b5\u30dd\u30fc\u30c8\u5916\u306e\u30a2\u30c0\u30d7\u30bf\u3067\u3059");
        }
        ResultSet rs = null;
        try {
            ArrayList<Map<String, Object>> ret = null;
            rs = params == null || params.length <= 0 ? record.executeQuery(sql) : record.executeQuery(sql, params, size);
            if (limit <= 0) {
                limit = Integer.MAX_VALUE;
            }
            if (offset <= 0) {
                offset = 0;
            }
            ret = new ArrayList<Map<String, Object>>();
            ExecutionDao.pushResult(ret, model, rs, columnLen, offset, limit);
            rs.close();
            rs = null;
            ArrayList<Map<String, Object>> arrayList = ret;
            return arrayList;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            rs = null;
        }
    }

    public static final List<Map<String, Object>> executionJoin(Record record, String model, MetaColumn meta, String sql, int offset, int limit, Object[] params, int size, Map<String, String> join, List<String> joinNameList) throws Exception {
        if (record == null) {
            return null;
        }
        if (sql == null || (sql = sql.trim()).length() <= 0) {
            throw new IllegalArgumentException("SQL\u6587\u306f\u4e0d\u6b63\u3067\u3059");
        }
        SupportKind kind = record.getSupportKind();
        if (kind == null) {
            throw new IOException("\u30b5\u30dd\u30fc\u30c8\u5916\u306e\u30a2\u30c0\u30d7\u30bf\u3067\u3059");
        }
        ResultSet rs = null;
        try {
            ArrayList<Map<String, Object>> ret = null;
            rs = params == null || params.length <= 0 ? record.executeQuery(sql) : record.executeQuery(sql, params, size);
            if (limit <= 0) {
                limit = Integer.MAX_VALUE;
            }
            if (offset <= 0) {
                offset = 0;
            }
            ret = new ArrayList<Map<String, Object>>();
            ExecutionDao.pushResultJoin(ret, model, rs, offset, limit, join, joinNameList);
            rs.close();
            rs = null;
            ArrayList<Map<String, Object>> arrayList = ret;
            return arrayList;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            rs = null;
        }
    }

    public static final List<Map<String, Object>> executionMany(Record record, String model, MetaColumn meta, String sql, int limit, Object[] params, int size, List<String> joinNameList) throws Exception {
        if (record == null) {
            return null;
        }
        if (sql == null || (sql = sql.trim()).length() <= 0) {
            throw new IllegalArgumentException("SQL\u6587\u306f\u4e0d\u6b63\u3067\u3059");
        }
        SupportKind kind = record.getSupportKind();
        if (kind == null) {
            throw new IOException("\u30b5\u30dd\u30fc\u30c8\u5916\u306e\u30a2\u30c0\u30d7\u30bf\u3067\u3059");
        }
        ResultSet rs = null;
        try {
            ArrayList<Map<String, Object>> ret = null;
            rs = params == null || params.length <= 0 ? record.executeQuery(sql) : record.executeQuery(sql, params, size);
            if (limit <= 0) {
                limit = Integer.MAX_VALUE;
            }
            ret = new ArrayList<Map<String, Object>>();
            ExecutionDao.pushResultMany(ret, model, rs, limit, joinNameList);
            rs.close();
            rs = null;
            ArrayList<Map<String, Object>> arrayList = ret;
            return arrayList;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            rs = null;
        }
    }

    protected static final StringBuilder createSQL(MetaColumn meta, DaoSession session) throws Exception {
        StringBuilder joinBuf = new StringBuilder().append("select ");
        int len = meta.size();
        int i = 0;
        while (i < len) {
            if (i != 0) {
                joinBuf.append(",");
            }
            joinBuf.append("a.").append(meta.getColumnName(i));
            ++i;
        }
        joinBuf.append(" from ").append(meta.getTable()).append(" a ");
        return joinBuf;
    }

    protected static final StringBuilder createJoinSQL(ArrayList<String> out, MetaColumn meta, DaoSession session, Map<String, String> join) throws Exception {
        Iterator<String> it = join.keySet().iterator();
        int cnt = 0;
        StringBuilder joinBuf = new StringBuilder().append("select ");
        int len = meta.size();
        int i = 0;
        while (i < len) {
            if (i != 0) {
                joinBuf.append(",");
            }
            joinBuf.append("a.").append(meta.getColumnName(i));
            ++i;
        }
        while (it.hasNext()) {
            String key = it.next();
            out.add(key);
            String tblName = join.get(key);
            MetaColumn m = session.getMeta(tblName);
            if (m == null) {
                throw new MaachangDaoException("\u6307\u5b9a\u30c6\u30fc\u30d6\u30eb\u540d[" + tblName + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
            len = m.size();
            int i2 = 0;
            while (i2 < len) {
                joinBuf.append(",b").append(cnt).append(".").append(m.getColumnName(i2));
                ++i2;
            }
            ++cnt;
        }
        cnt = 0;
        joinBuf.append(" from ").append(meta.getTable()).append(" a ");
        len = out.size();
        i = 0;
        while (i < len) {
            String key = out.get(i);
            String value = DbUtil.convertJavaNameByDBName(join.get(key));
            joinBuf.append("left outer join ").append(value).append(" b").append(i).append(" on a.").append(DbUtil.convertJavaNameByDBName(key)).append("=b").append(i).append(".id ");
            ++i;
        }
        return joinBuf;
    }

    protected static final StringBuilder createManySQL(ArrayList<String> out, MetaColumn meta, DaoSession session, Map<String, String> srcJoin) throws Exception {
        Iterator<String> it = srcJoin.keySet().iterator();
        int cnt = 0;
        StringBuilder joinBuf = new StringBuilder().append("select ");
        int len = meta.size();
        int i = 0;
        while (i < len) {
            if (i != 0) {
                joinBuf.append(",");
            }
            joinBuf.append("a.").append(meta.getColumnName(i));
            ++i;
        }
        while (it.hasNext()) {
            String key = it.next();
            out.add(key);
            MetaColumn m = session.getMeta(key);
            if (m == null) {
                throw new MaachangDaoException("\u6307\u5b9a\u30c6\u30fc\u30d6\u30eb\u540d[" + key + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
            len = m.size();
            int i2 = 0;
            while (i2 < len) {
                joinBuf.append(",b").append(cnt).append(".").append(m.getColumnName(i2));
                ++i2;
            }
            ++cnt;
        }
        cnt = 0;
        joinBuf.append(" from ").append(meta.getTable()).append(" a ");
        len = out.size();
        i = 0;
        while (i < len) {
            String key = out.get(i);
            String tblName = DbUtil.convertJavaNameByDBName(key);
            String value = DbUtil.convertJavaNameByDBName(srcJoin.get(key));
            joinBuf.append("left outer join ").append(tblName).append(" b").append(i);
            joinBuf.append(" on a.id=b").append(i).append(".").append(value).append(" ");
            ++i;
        }
        return joinBuf;
    }

    protected static final String addWhereByTableSimbol(String where, MetaColumn meta) throws Exception {
        if (where == null || where.length() <= 0) {
            return null;
        }
        int len = meta.size();
        int i = 0;
        while (i < len) {
            int p;
            String key = meta.getColumnName(i);
            int keyLen = key.length();
            int b = 0;
            while ((p = where.indexOf(key, b)) > -1) {
                boolean execFlg = false;
                if (p <= 0 || where.charAt(p - 1) == ' ') {
                    int e = p + keyLen;
                    if (where.length() >= e) {
                        execFlg = true;
                    } else {
                        char c = where.charAt(e + 1);
                        if (c == ' ' || c == '=' || c == '>' || c == '<' || c == '!') {
                            execFlg = true;
                        }
                    }
                    if (execFlg) {
                        where = where.substring(0, p) + "a." + where.substring(p);
                        b = p + keyLen + 2;
                        continue;
                    }
                    b = p + keyLen;
                    continue;
                }
                b = p + 1;
            }
            ++i;
        }
        return where;
    }

    public static final boolean isSequence(MetaColumn meta) throws Exception {
        int len = meta.size();
        int i = 0;
        while (i < len) {
            if (SEQ_COLUMN.equals(meta.getColumnName(i).toLowerCase()) && meta.getColumnType(i) == -5) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final boolean isOptimisticLock(MetaColumn meta) throws Exception {
        int len = meta.size();
        int i = 0;
        while (i < len) {
            if (OPTIMISTIC_LOCK_COLUMN.equals(meta.getColumnName(i).toLowerCase()) && meta.getColumnType(i) == -5) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final boolean isCreateTime(MetaColumn meta) throws Exception {
        int len = meta.size();
        int i = 0;
        while (i < len) {
            if (CREATE_TIME.equals(meta.getColumnName(i).toLowerCase())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final boolean isUpdateTime(MetaColumn meta) throws Exception {
        int len = meta.size();
        int i = 0;
        while (i < len) {
            if (UPDATE_TIME.equals(meta.getColumnName(i).toLowerCase())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static final Long getSequenceId(Record record, String sql) throws Exception {
        ResultSet result = null;
        result = record.executeQuery(sql);
        if (result != null) {
            Long ret;
            result.next();
            Long l = ret = Long.valueOf(result.getLong(1));
            return l;
        }
        Long l = null;
        return l;
        {
            finally {
                if (result != null) {
                    try {
                        result.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private static final Long getInsertId(Record record, String sql) throws Exception {
        ResultSet result = null;
        result = record.executeQuery(sql);
        if (result != null) {
            Long ret;
            result.next();
            Long l = ret = Long.valueOf(result.getLong(1));
            return l;
        }
        Long l = null;
        return l;
        {
            finally {
                if (result != null) {
                    try {
                        result.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private static final void pushResult(ArrayList<Map<String, Object>> out, String model, ResultSet result, int columnLen, int offset, int limit) throws Exception {
        ResultUtil.setPosition(result, offset);
        MetaColumn meta = null;
        int i = 0;
        while (i < limit) {
            if (!result.next()) break;
            if (meta == null && columnLen != (meta = MetaFactory.getInstance().getMetaColumn(true, model)).size()) {
                meta = new MetaColumn(model, result.getMetaData());
            }
            HashMap<String, Object> o = new HashMap<String, Object>();
            ExecutionDao.convertResultByObject(o, meta, result, columnLen);
            out.add(o);
            ++i;
        }
    }

    private static final void pushResultJoin(ArrayList<Map<String, Object>> out, String model, ResultSet result, int offset, int limit, Map<String, String> join, List<String> joinNameList) throws Exception {
        ResultUtil.setPosition(result, offset);
        int i = 0;
        while (i < limit) {
            if (!result.next()) break;
            HashMap<String, Object> o = new HashMap<String, Object>();
            ExecutionDao.convertResultByObjectJoin(o, model, result, join, joinNameList);
            out.add(o);
            ++i;
        }
    }

    private static final void pushResultMany(ArrayList<Map<String, Object>> out, String model, ResultSet result, int limit, List<String> joinNameList) throws Exception {
        Long targetId = null;
        HashMap<String, Object> mainColumn = null;
        MetaColumn meta = null;
        block0: while (true) {
            String javaName;
            Object value;
            int type;
            int i;
            int len;
            if (!result.next()) {
                if (mainColumn == null) break;
                out.add(mainColumn);
                break;
            }
            meta = MetaFactory.getInstance().getMetaColumn(true, model);
            if (targetId == null) {
                mainColumn = new HashMap<String, Object>();
                len = meta.size();
                i = 0;
                while (i < len) {
                    type = meta.getColumnType(i);
                    String name = meta.getColumnName(i);
                    value = ExecutionDao.getParamByNo(result, type, i + 1);
                    javaName = DbUtil.convertDBNameByJavaName(false, name);
                    ExecutionDao.putResult(mainColumn, type, javaName, value);
                    ++i;
                }
                targetId = (Long)mainColumn.get(SEQ_COLUMN);
            } else {
                len = meta.size();
                if (SEQ_COLUMN.equals(meta.getColumnName(0)) && !targetId.equals(ExecutionDao.getParamByNo(result, meta.getColumnType(0), 1))) {
                    if (mainColumn != null) {
                        out.add(mainColumn);
                        if (limit == 1) break;
                    }
                    mainColumn = new HashMap();
                    i = 0;
                    while (i < len) {
                        type = meta.getColumnType(i);
                        String name = meta.getColumnName(i);
                        value = ExecutionDao.getParamByNo(result, type, i + 1);
                        javaName = DbUtil.convertDBNameByJavaName(false, name);
                        ExecutionDao.putResult(mainColumn, type, javaName, value);
                        ++i;
                    }
                    targetId = (Long)mainColumn.get(SEQ_COLUMN);
                }
            }
            int startPos = meta.size();
            int len2 = joinNameList.size();
            int i2 = 0;
            while (true) {
                if (i2 >= len2) continue block0;
                boolean noDataFlag = false;
                String tblName = MANY_JOIN_NAME + joinNameList.get(i2);
                HashMap<String, Object> joinElement = new HashMap<String, Object>();
                meta = MetaFactory.getInstance().getMetaColumn(true, joinNameList.get(i2));
                int lenJ = meta.size();
                int j = 0;
                while (j < lenJ) {
                    int type2 = meta.getColumnType(j);
                    String name = meta.getColumnName(j);
                    Object value2 = ExecutionDao.getParamByNo(result, type2, j + startPos + 1);
                    if (j == 0 && value2 == null) {
                        noDataFlag = true;
                        break;
                    }
                    String javaName2 = DbUtil.convertDBNameByJavaName(false, name);
                    ExecutionDao.putResult(joinElement, type2, javaName2, value2);
                    ++j;
                }
                startPos += lenJ;
                if (!noDataFlag) {
                    ArrayList<HashMap<String, Object>> lst = (ArrayList<HashMap<String, Object>>)mainColumn.get(tblName);
                    if (lst == null) {
                        lst = new ArrayList<HashMap<String, Object>>();
                        mainColumn.put(tblName, lst);
                    }
                    lst.add(joinElement);
                }
                joinElement = null;
                ++i2;
            }
            break;
        }
    }

    public static final void convertResultByObject(Map<String, Object> out, MetaColumn meta, ResultSet result, int columnLen) throws Exception {
        if (out == null || meta == null || result == null) {
            return;
        }
        int i = 0;
        while (i < columnLen) {
            int type = meta.getColumnType(i);
            String name = meta.getColumnName(i);
            Object value = ExecutionDao.getParamByNo(result, type, i + 1);
            String javaName = DbUtil.convertDBNameByJavaName(false, name);
            ExecutionDao.putResult(out, type, javaName, value);
            ++i;
        }
    }

    public static final void convertResultByObjectJoin(Map<String, Object> out, String model, ResultSet result, Map<String, String> join, List<String> joinNameList) throws Exception {
        if (out == null || model == null || result == null || join == null || joinNameList == null) {
            return;
        }
        MetaColumn meta = MetaFactory.getInstance().getMetaColumn(true, model);
        int len = meta.size();
        int i = 0;
        while (i < len) {
            int type = meta.getColumnType(i);
            String name = meta.getColumnName(i);
            Object value = ExecutionDao.getParamByNo(result, type, i + 1);
            String javaName = DbUtil.convertDBNameByJavaName(false, name);
            ExecutionDao.putResult(out, type, javaName, value);
            ++i;
        }
        int startPos = len;
        len = joinNameList.size();
        HashMap<String, Object> joinElement = null;
        int i2 = 0;
        while (i2 < len) {
            joinElement = new HashMap<String, Object>();
            meta = MetaFactory.getInstance().getMetaColumn(true, join.get(joinNameList.get(i2)));
            int lenJ = meta.size();
            int j = 0;
            while (j < lenJ) {
                int type = meta.getColumnType(j);
                String name = meta.getColumnName(j);
                Object value = ExecutionDao.getParamByNo(result, type, j + startPos + 1);
                String javaName = DbUtil.convertDBNameByJavaName(false, name);
                ExecutionDao.putResult(joinElement, type, javaName, value);
                ++j;
            }
            startPos += lenJ;
            out.put(joinNameList.get(i2), joinElement);
            joinElement = null;
            ++i2;
        }
    }

    private static final void putResult(Map<String, Object> result, int type, String name, Object value) throws Exception {
        if (value != null) {
            String c;
            if (type == 1 && (c = (String)value).length() == 1) {
                value = c.equals("0") ? new Boolean(false) : new Boolean(true);
            }
            result.put(name, value);
        } else {
            result.put(name, null);
        }
    }

    private static final Object getParamByNo(ResultSet result, int type, int no) throws Exception {
        if (result.getObject(no) == null) {
            return null;
        }
        Object data = null;
        switch (type) {
            case -7: {
                data = new Boolean(result.getBoolean(no));
                break;
            }
            case 16: {
                data = new Boolean(result.getBoolean(no));
                break;
            }
            case -6: {
                data = new Byte(result.getByte(no));
                if (data == null) break;
                byte b = (Byte)data;
                if (b == 1) {
                    data = new Boolean(true);
                }
                data = new Boolean(false);
                break;
            }
            case 5: {
                data = new Integer(result.getInt(no));
                break;
            }
            case 4: {
                data = new Integer(result.getInt(no));
                break;
            }
            case -5: {
                data = new Long(result.getLong(no));
                break;
            }
            case 6: {
                data = new Float(result.getFloat(no));
                break;
            }
            case 7: {
                data = new Float(result.getFloat(no));
                break;
            }
            case 8: {
                data = new Double(result.getDouble(no));
                break;
            }
            case 2: {
                data = result.getBigDecimal(no);
                break;
            }
            case 3: {
                data = result.getBigDecimal(no);
                break;
            }
            case 1: {
                data = result.getString(no);
                break;
            }
            case 12: {
                data = result.getString(no);
                break;
            }
            case -1: {
                data = result.getString(no);
                break;
            }
            case 91: {
                data = result.getDate(no);
                break;
            }
            case 92: {
                data = result.getTime(no);
                break;
            }
            case 93: {
                data = result.getTimestamp(no);
                break;
            }
            case -2: {
                data = result.getBytes(no);
                break;
            }
            case -3: {
                data = result.getBytes(no);
                break;
            }
            case -4: {
                data = result.getBytes(no);
                break;
            }
            case 2004: {
                data = result.getBlob(no);
                break;
            }
            case 70: 
            case 2002: 
            case 2005: 
            case 2006: 
            case 2011: {
                data = result.getString(no);
                break;
            }
            default: {
                data = null;
            }
        }
        if (data == null) {
            return null;
        }
        if (data instanceof Blob) {
            int len;
            BufferedInputStream b = new BufferedInputStream(((Blob)data).getBinaryStream());
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            byte[] bin = new byte[4096];
            while ((len = ((InputStream)b).read(bin)) > -1) {
                if (len == 0) continue;
                bo.write(bin, 0, len);
            }
            ((InputStream)b).close();
            b = null;
            data = bo.toByteArray();
            bo.close();
            bo = null;
        }
        return data;
    }
}

