/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dao.dbms;

import java.io.IOException;
import java.util.ArrayList;
import org.maachang.dao.dbms.MetaColumn;
import org.maachang.dao.dbms.MetaFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbUtil {
    public static final String convertJavaNameByDBName(String name) {
        if (name == null || (name = name.trim()).length() <= 0) {
            return null;
        }
        if (name.indexOf("_") != -1) {
            if (DbUtil.isBigAZ(name, 0)) {
                return name.toLowerCase();
            }
            return name;
        }
        int len = name.length();
        StringBuilder buf = new StringBuilder();
        buf.append(name.charAt(0));
        int i = 1;
        while (i < len) {
            char c = name.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                buf.append("_");
            }
            buf.append(c);
            ++i;
        }
        String ret = buf.toString().toLowerCase();
        return ret;
    }

    public static final String convertDBNameByJavaName(boolean table, String name) {
        char c;
        if (name == null || (name = name.trim()).length() <= 0) {
            return null;
        }
        name = name.toLowerCase();
        int len = name.length();
        StringBuilder buf = new StringBuilder();
        buf.append(name.charAt(0));
        int i = 1;
        while (i < len) {
            c = name.charAt(i);
            if (c == '_') {
                char cp;
                if (i + 1 < len && (cp = name.charAt(i + 1)) >= 'a' && cp <= 'z') {
                    buf.append((char)(65 + (cp - 97)));
                    ++i;
                }
            } else {
                buf.append(c);
            }
            ++i;
        }
        String ret = buf.toString();
        buf = null;
        if (table && (c = ret.charAt(0)) >= 'a' && c <= 'z') {
            buf = new StringBuilder();
            buf.append((char)(65 + (c - 97))).append(ret.substring(1, ret.length()));
            ret = buf.toString();
        }
        return ret;
    }

    public static final ArrayList<String> cutCsv(boolean cote, String line, String cutCode) throws Exception {
        if (line == null || line.length() <= 0) {
            return new ArrayList<String>();
        }
        if (cutCode == null || cutCode.length() <= 0) {
            cutCode = ",";
        }
        ArrayList<String> tmp = new ArrayList<String>();
        int p = -1;
        int b = 0;
        int cutLen = cutCode.length();
        while (true) {
            if ((p = line.indexOf(cutCode, b)) <= -1) {
                if (b == 0) {
                    tmp.add(line);
                    break;
                }
                if (line.length() <= b) break;
                tmp.add(line.substring(b));
                break;
            }
            char c = line.charAt(b);
            if (c == '\'' || c == '\"') {
                int x = line.indexOf(c, b + 1);
                if (x <= -1) {
                    tmp.add(line.substring(b) + c);
                    break;
                }
                tmp.add(line.substring(b, x + 1));
                b = x + 1 + cutLen;
                continue;
            }
            tmp.add(line.substring(b, p));
            b = p + cutLen;
        }
        ArrayList<String> ret = new ArrayList<String>();
        int len = tmp.size();
        int i = 0;
        while (i < len) {
            String x = (String)tmp.get(i);
            if (cote && x.startsWith("'") && x.endsWith("'")) {
                ret.add("\"" + x.substring(1, x.length() - 1) + "\"");
            } else if (!cote && x.startsWith("\"") && x.endsWith("\"")) {
                ret.add("'" + x.substring(1, x.length() - 1) + "'");
            } else {
                ret.add(x);
            }
            ++i;
        }
        tmp.clear();
        tmp = null;
        return ret;
    }

    public static final String trimWhere(String where, String modelName) throws Exception {
        MetaColumn meta = MetaFactory.getInstance().getMetaColumn(true, modelName);
        if (meta == null) {
            throw new IOException("\u6307\u5b9a\u30c6\u30fc\u30d6\u30eb\u540d[" + modelName + "]\u306eModel\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        return DbUtil.trimWhere(where, meta);
    }

    public static final String trimWhere(String where, MetaColumn meta) throws Exception {
        where = where.trim();
        int len = meta.size();
        int i = 0;
        while (i < len) {
            String key = null;
            int j = 0;
            while (j < 2) {
                int p;
                key = j == 0 ? meta.getColumnName(false, i) : meta.getColumnName(true, i);
                int keyLen = key.length();
                int b = 0;
                int order = where.indexOf("order by");
                while ((p = where.indexOf(key, b)) > -1) {
                    if (p <= 0 || !DbUtil.isUseChar(where.charAt(p - 1)) && !DbUtil.isColumnSimbol(where.charAt(p - 1))) {
                        if (order != -1 && p >= order) break;
                        int e = p + keyLen;
                        if (where.length() >= e || !DbUtil.isUseChar(where.charAt(e + 1))) {
                            where = j == 0 ? where.substring(0, p) + "$" + key + where.substring(p + keyLen) : where.substring(0, p) + "$" + meta.getColumnName(false, i) + where.substring(p + keyLen);
                            b = p + keyLen + 1;
                            continue;
                        }
                        b = p + keyLen;
                        continue;
                    }
                    b = p + 1;
                }
                ++j;
            }
            ++i;
        }
        return where;
    }

    private static final boolean isBigAZ(String string, int pos) {
        int len = string.length();
        int i = pos;
        while (i < len) {
            char c = string.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static final boolean isUseChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '.' || c == '_';
    }

    private static final boolean isColumnSimbol(char c) {
        return c == '$' || c == ':';
    }
}

